/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.test.broker.protocol;

import io.camunda.zeebe.protocol.record.ImmutableProtocol;
import io.camunda.zeebe.protocol.record.ImmutableRecord;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.RecordType;
import io.camunda.zeebe.protocol.record.RecordValue;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.ValueTypeMapping;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.value.ImmutableAsyncRequestRecordValue;
import io.camunda.zeebe.protocol.record.value.ImmutableCommandDistributionRecordValue;
import io.camunda.zeebe.test.broker.protocol.EnumRandomizer;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ClassInfoList;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import org.jeasy.random.EasyRandom;
import org.jeasy.random.EasyRandomParameters;
import org.jeasy.random.FieldPredicates;
import org.jeasy.random.api.Randomizer;
import org.jeasy.random.api.RandomizerRegistry;
import org.jeasy.random.randomizers.range.LongRangeRandomizer;
import org.jeasy.random.randomizers.registry.CustomRandomizerRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ProtocolFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProtocolFactory.class);
    private static final String PROTOCOL_PACKAGE_NAME = Record.class.getPackage().getName() + "*";
    private final CustomRandomizerRegistry randomizerRegistry = new CustomRandomizerRegistry();
    private final EasyRandomParameters parameters;
    private final EasyRandom random;

    public ProtocolFactory() {
        this(0L);
    }

    public ProtocolFactory(long seed) {
        this.parameters = this.getDefaultParameters().seed(seed).scanClasspathForConcreteTypes(true);
        this.random = new EasyRandom(this.parameters);
        this.registerRandomizers();
    }

    public <T extends RecordValue> Stream<Record<T>> generateRecords() {
        return this.generateRecords(UnaryOperator.identity());
    }

    public <T extends RecordValue> Stream<Record<T>> generateRecords(UnaryOperator<ImmutableRecord.Builder<T>> modifier) {
        return Stream.generate(() -> this.generateRecord(modifier));
    }

    public <T extends RecordValue> Stream<Record<T>> generateForAllValueTypes() {
        return this.generateForAllValueTypes(UnaryOperator.identity());
    }

    public <T extends RecordValue> Stream<Record<T>> generateForAllValueTypes(UnaryOperator<ImmutableRecord.Builder<T>> modifier) {
        return ValueTypeMapping.getAcceptedValueTypes().stream().map(valueType -> this.generateRecord((ValueType)valueType, modifier));
    }

    public <T extends RecordValue> Record<T> generateRecord() {
        return this.generateRecord(UnaryOperator.identity());
    }

    public <T extends RecordValue> Record<T> generateRecord(UnaryOperator<ImmutableRecord.Builder<T>> modifier) {
        ValueType valueType = (ValueType)this.random.nextObject(ValueType.class);
        return this.generateRecord(valueType, modifier);
    }

    public <T extends RecordValue> Record<T> generateRecord(ValueType valueType) {
        return this.generateRecord(valueType, UnaryOperator.identity());
    }

    public <T extends RecordValue> Record<T> generateRecordWithIntent(ValueType valueType, Intent intent) {
        return this.generateRecord(valueType, UnaryOperator.identity(), intent);
    }

    public <T extends RecordValue> Record<T> generateRecord(ValueType valueType, UnaryOperator<ImmutableRecord.Builder<T>> modifier) {
        return this.generateImmutableRecord(valueType, modifier, null);
    }

    public <T extends RecordValue> Record<T> generateRecord(ValueType valueType, UnaryOperator<ImmutableRecord.Builder<T>> modifier, Intent intent) {
        return this.generateImmutableRecord(valueType, modifier, intent);
    }

    public <T> T generateObject(Class<T> objectClass) {
        return (T)this.random.nextObject(objectClass);
    }

    public long getSeed() {
        return this.parameters.getSeed();
    }

    private void registerRandomizers() {
        ProtocolFactory.findProtocolTypes().forEach(this::registerProtocolType);
        this.randomizerRegistry.registerRandomizer(Object.class, (Randomizer)new RawObjectRandomizer());
        this.randomizerRegistry.registerRandomizer(Long.class, (Randomizer)new LongRangeRandomizer(Long.valueOf(0L), Long.valueOf(Long.MAX_VALUE), this.getSeed()));
        this.randomizerRegistry.registerRandomizer(Long.TYPE, (Randomizer)new LongRangeRandomizer(Long.valueOf(0L), Long.valueOf(Long.MAX_VALUE), this.getSeed()));
        this.randomizerRegistry.registerRandomizer(ValueType.class, (Randomizer)new EnumRandomizer(this.getSeed(), (Enum[])((ValueType[])ValueTypeMapping.getAcceptedValueTypes().toArray(ValueType[]::new))));
        EnumSet<RecordType> excludedRecordTypes = EnumSet.of(RecordType.NULL_VAL, RecordType.SBE_UNKNOWN);
        EnumSet<RecordType> recordTypes = EnumSet.complementOf(excludedRecordTypes);
        this.randomizerRegistry.registerRandomizer(RecordType.class, (Randomizer)new EnumRandomizer(this.getSeed(), (Enum[])((RecordType[])recordTypes.toArray(RecordType[]::new))));
        this.randomizerRegistry.registerRandomizer(ImmutableCommandDistributionRecordValue.class, () -> {
            ValueType valueType = (ValueType)this.random.nextObject(ValueType.class);
            ValueTypeMapping.Mapping typeInfo = ValueTypeMapping.get((ValueType)valueType);
            return ImmutableCommandDistributionRecordValue.builder().withPartitionId(this.random.nextInt()).withQueueId((String)this.random.nextObject(String.class)).withValueType(valueType).withIntent((Intent)this.random.nextObject(typeInfo.getIntentClass())).withCommandValue((RecordValue)this.generateObject(typeInfo.getValueClass())).build();
        });
        this.randomizerRegistry.registerRandomizer(ImmutableAsyncRequestRecordValue.class, () -> {
            ValueType valueType = (ValueType)this.random.nextObject(ValueType.class);
            ValueTypeMapping.Mapping typeInfo = ValueTypeMapping.get((ValueType)valueType);
            return ImmutableAsyncRequestRecordValue.builder().withScopeKey(this.random.nextLong()).withValueType(valueType).withIntent((Intent)this.random.nextObject(typeInfo.getIntentClass())).withRequestId(this.random.nextLong()).withRequestStreamId(this.random.nextInt()).withOperationReference(this.random.nextLong()).build();
        });
    }

    private void registerProtocolType(ClassInfo abstractType) {
        List implementations = abstractType.getClassesImplementing().filter(info -> info.hasAnnotation(ImmutableProtocol.Type.class)).directOnly().loadClasses();
        if (implementations.isEmpty()) {
            LOGGER.warn("No implementations found for abstract protocol type {}; random generation will not be possible for this type", (Object)abstractType.getName());
            return;
        }
        Class implementation = (Class)implementations.get(0);
        if (implementations.size() > 1) {
            LOGGER.warn("More than one implementation found for abstract protocol type {}; random generation will use the first one: {}", (Object)abstractType.getName(), (Object)implementation.getName());
        }
        this.randomizerRegistry.registerRandomizer(abstractType.loadClass(), () -> this.random.nextObject(implementation));
    }

    private EasyRandomParameters getDefaultParameters() {
        Predicate excludedRecordFields = FieldPredicates.inClass(ImmutableRecord.class).and(FieldPredicates.named((String)"value").or(FieldPredicates.named((String)"intent")).or(FieldPredicates.named((String)"valueType")));
        return new EasyRandomParameters().randomizerRegistry((RandomizerRegistry)this.randomizerRegistry).bypassSetters(true).collectionSizeRange(0, 5).randomizationDepth(8).excludeField(excludedRecordFields);
    }

    private <T extends RecordValue> Record<T> generateImmutableRecord(ValueType valueType, UnaryOperator<ImmutableRecord.Builder<T>> modifier, Intent fixedIntent) {
        Objects.requireNonNull(valueType, "must specify a value type");
        Objects.requireNonNull(modifier, "must specify a builder modifier");
        ValueTypeMapping.Mapping typeInfo = ValueTypeMapping.get((ValueType)valueType);
        Intent intent = fixedIntent == null ? (Intent)this.random.nextObject(typeInfo.getIntentClass()) : fixedIntent;
        RecordValue value = (RecordValue)this.generateObject(typeInfo.getValueClass());
        Record seedRecord = (Record)this.random.nextObject(Record.class);
        ImmutableRecord.Builder builder = ImmutableRecord.builder().from(seedRecord).withValueType(valueType).withValue(value).withIntent(intent);
        return Objects.requireNonNull((ImmutableRecord.Builder)modifier.apply(builder), "must return a non null builder").build();
    }

    static ClassInfoList findProtocolTypes() {
        return new ClassGraph().acceptPackages(new String[]{PROTOCOL_PACKAGE_NAME}).enableAnnotationInfo().scan().getAllInterfaces().filter(info -> info.hasAnnotation(ImmutableProtocol.class)).directOnly();
    }

    private final class RawObjectRandomizer
    implements Randomizer<Object> {
        private final Class<?>[] variableTypes = new Class[]{Boolean.class, Long.class, String.class};

        private RawObjectRandomizer() {
        }

        public Object getRandomValue() {
            Class<?> variableType = this.variableTypes[ProtocolFactory.this.random.nextInt(this.variableTypes.length)];
            return ProtocolFactory.this.random.nextObject(variableType);
        }
    }
}

