/*
 * Copyright Camunda Services GmbH and/or licensed to Camunda Services GmbH under
 * one or more contributor license agreements. See the NOTICE file distributed
 * with this work for additional information regarding copyright ownership.
 * Licensed under the Camunda License 1.0. You may not use this file
 * except in compliance with the Camunda License 1.0.
 */
package io.camunda.zeebe.test.broker.protocol.brokerapi;

import io.camunda.zeebe.protocol.record.ExecuteCommandRequestDecoder;
import io.camunda.zeebe.protocol.record.MessageHeaderDecoder;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.test.broker.protocol.MsgPackHelper;
import io.camunda.zeebe.util.buffer.BufferReader;
import java.util.Map;
import org.agrona.DirectBuffer;
import org.agrona.io.DirectBufferInputStream;

public final class ExecuteCommandRequest implements BufferReader {

  protected final MessageHeaderDecoder headerDecoder = new MessageHeaderDecoder();
  protected final ExecuteCommandRequestDecoder bodyDecoder = new ExecuteCommandRequestDecoder();

  protected final MsgPackHelper msgPackHelper;

  protected Map<String, Object> command;

  public ExecuteCommandRequest(final MsgPackHelper msgPackHelper) {
    this.msgPackHelper = msgPackHelper;
  }

  public long key() {
    return bodyDecoder.key();
  }

  public int partitionId() {
    return bodyDecoder.partitionId();
  }

  public ValueType valueType() {
    return bodyDecoder.valueType();
  }

  public Intent intent() {
    return Intent.fromProtocolValue(valueType(), bodyDecoder.intent());
  }

  public Map<String, Object> getCommand() {
    return command;
  }

  @Override
  public void wrap(final DirectBuffer buffer, final int offset, final int length) {
    headerDecoder.wrap(buffer, offset);

    bodyDecoder.wrap(
        buffer,
        offset + headerDecoder.encodedLength(),
        headerDecoder.blockLength(),
        headerDecoder.version());

    final int commandLength = bodyDecoder.valueLength();
    final int commandOffset =
        bodyDecoder.limit() + ExecuteCommandRequestDecoder.valueHeaderLength();

    command =
        msgPackHelper.readMsgPack(
            new DirectBufferInputStream(buffer, commandOffset, commandLength));
  }
}
