/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.test.broker.protocol.commandapi;

import io.camunda.zeebe.protocol.record.ErrorCode;
import io.camunda.zeebe.protocol.record.ErrorResponseDecoder;
import io.camunda.zeebe.protocol.record.MessageHeaderDecoder;
import io.camunda.zeebe.test.broker.protocol.MsgPackHelper;
import io.camunda.zeebe.util.buffer.BufferReader;
import org.agrona.DirectBuffer;

public final class ErrorResponse
implements BufferReader {
    protected final MsgPackHelper msgPackHelper;
    protected String errorData;
    private final MessageHeaderDecoder messageHeaderDecoder = new MessageHeaderDecoder();
    private final ErrorResponseDecoder bodyDecoder = new ErrorResponseDecoder();

    public ErrorResponse(MsgPackHelper msgPackHelper) {
        this.msgPackHelper = msgPackHelper;
    }

    public ErrorCode getErrorCode() {
        return this.bodyDecoder.errorCode();
    }

    public String getErrorData() {
        return this.errorData;
    }

    public void wrap(DirectBuffer responseBuffer, int offset, int length) {
        this.messageHeaderDecoder.wrap(responseBuffer, 0);
        if (this.messageHeaderDecoder.templateId() != this.bodyDecoder.sbeTemplateId()) {
            throw new RuntimeException("Unexpected response from broker.");
        }
        this.bodyDecoder.wrap(responseBuffer, this.messageHeaderDecoder.encodedLength(), this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
        int errorDataLength = this.bodyDecoder.errorDataLength();
        int errorDataOffset = this.messageHeaderDecoder.encodedLength() + this.messageHeaderDecoder.blockLength() + ErrorResponseDecoder.errorDataHeaderLength();
        this.errorData = responseBuffer.getStringWithoutLengthUtf8(errorDataOffset, errorDataLength);
        this.bodyDecoder.limit(errorDataOffset + errorDataLength);
    }
}

