/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.test.broker.protocol.brokerapi;

import io.camunda.zeebe.protocol.record.ExecuteCommandResponseEncoder;
import io.camunda.zeebe.protocol.record.MessageHeaderEncoder;
import io.camunda.zeebe.protocol.record.RecordType;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.test.broker.protocol.MsgPackHelper;
import io.camunda.zeebe.test.broker.protocol.brokerapi.AbstractMessageBuilder;
import io.camunda.zeebe.test.broker.protocol.brokerapi.ExecuteCommandRequest;
import io.camunda.zeebe.util.EnsureUtil;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.function.Function;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public final class ExecuteCommandResponseWriter
extends AbstractMessageBuilder<ExecuteCommandRequest> {
    protected final MessageHeaderEncoder headerEncoder = new MessageHeaderEncoder();
    protected final ExecuteCommandResponseEncoder bodyEncoder = new ExecuteCommandResponseEncoder();
    protected final MsgPackHelper msgPackHelper;
    protected Function<ExecuteCommandRequest, Long> keyFunction = r -> r.key();
    protected Function<ExecuteCommandRequest, Integer> partitionIdFunction = r -> r.partitionId();
    protected Function<ExecuteCommandRequest, Map<String, Object>> eventFunction;
    protected long key;
    protected int partitionId;
    protected byte[] value;
    private Function<ExecuteCommandRequest, Intent> intentFunction = r -> r.intent();
    private RecordType recordType;
    private Intent intent;
    private ValueType valueType;
    private RejectionType rejectionType = RejectionType.NULL_VAL;
    private UnsafeBuffer rejectionReason = new UnsafeBuffer(0L, 0);

    public ExecuteCommandResponseWriter(MsgPackHelper msgPackHelper) {
        this.msgPackHelper = msgPackHelper;
    }

    @Override
    public void initializeFrom(ExecuteCommandRequest request) {
        this.key = this.keyFunction.apply(request);
        this.partitionId = this.partitionIdFunction.apply(request);
        Map<String, Object> deserializedEvent = this.eventFunction.apply(request);
        this.value = this.msgPackHelper.encodeAsMsgPack(deserializedEvent);
        this.valueType = request.valueType();
        this.intent = this.intentFunction.apply(request);
    }

    public void setPartitionIdFunction(Function<ExecuteCommandRequest, Integer> partitionIdFunction) {
        this.partitionIdFunction = partitionIdFunction;
    }

    public void setEventFunction(Function<ExecuteCommandRequest, Map<String, Object>> eventFunction) {
        this.eventFunction = eventFunction;
    }

    public void setRecordType(RecordType recordType) {
        this.recordType = recordType;
    }

    public void setKeyFunction(Function<ExecuteCommandRequest, Long> keyFunction) {
        this.keyFunction = keyFunction;
    }

    public void setIntentFunction(Function<ExecuteCommandRequest, Intent> intentFunction) {
        this.intentFunction = intentFunction;
    }

    public void setRejectionType(RejectionType rejectionType) {
        this.rejectionType = rejectionType;
    }

    public void setRejectionReason(String rejectionReason) {
        byte[] bytes = rejectionReason.getBytes(StandardCharsets.UTF_8);
        this.rejectionReason = new UnsafeBuffer(bytes);
    }

    public int getLength() {
        return 22 + ExecuteCommandResponseEncoder.valueHeaderLength() + this.value.length + ExecuteCommandResponseEncoder.rejectionReasonHeaderLength() + this.rejectionReason.capacity();
    }

    public void write(MutableDirectBuffer buffer, int offset) {
        EnsureUtil.ensureNotNull((String)"recordType", (Object)this.recordType);
        EnsureUtil.ensureNotNull((String)"valueType", (Object)this.valueType);
        EnsureUtil.ensureNotNull((String)"intent", (Object)this.intent);
        this.headerEncoder.wrap(buffer, offset).blockLength(this.bodyEncoder.sbeBlockLength()).templateId(this.bodyEncoder.sbeTemplateId()).schemaId(this.bodyEncoder.sbeSchemaId()).version(this.bodyEncoder.sbeSchemaVersion());
        this.bodyEncoder.wrap(buffer, offset += this.headerEncoder.encodedLength()).recordType(this.recordType).valueType(this.valueType).intent(this.intent.value()).partitionId(this.partitionId).key(this.key).rejectionType(this.rejectionType).putValue(this.value, 0, this.value.length).putRejectionReason((DirectBuffer)this.rejectionReason, 0, this.rejectionReason.capacity());
    }
}

