/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.test.broker.protocol.commandapi;

import io.camunda.zeebe.protocol.record.ExecuteCommandResponseDecoder;
import io.camunda.zeebe.protocol.record.MessageHeaderDecoder;
import io.camunda.zeebe.protocol.record.RecordType;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.test.broker.protocol.MsgPackHelper;
import io.camunda.zeebe.test.broker.protocol.commandapi.ErrorResponse;
import io.camunda.zeebe.util.buffer.BufferReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.agrona.DirectBuffer;
import org.agrona.LangUtil;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.io.DirectBufferInputStream;

public final class ExecuteCommandResponse
implements BufferReader {
    protected final ErrorResponse errorResponse;
    protected final MsgPackHelper msgPackHelper;
    protected Map<String, Object> value;
    private final MessageHeaderDecoder messageHeaderDecoder = new MessageHeaderDecoder();
    private final ExecuteCommandResponseDecoder responseDecoder = new ExecuteCommandResponseDecoder();
    private final DirectBuffer responseBuffer = new UnsafeBuffer();
    private int valueLengthOffset;
    private String rejectionReason;

    public ExecuteCommandResponse(MsgPackHelper msgPackHelper) {
        this.msgPackHelper = msgPackHelper;
        this.errorResponse = new ErrorResponse(msgPackHelper);
    }

    public Map<String, Object> getValue() {
        return this.value;
    }

    public DirectBuffer getRawValue() {
        this.responseDecoder.limit(this.valueLengthOffset);
        int valueLength = this.responseDecoder.valueLength();
        int valueOffset = this.valueLengthOffset + ExecuteCommandResponseDecoder.valueHeaderLength();
        UnsafeBuffer buf = new UnsafeBuffer(this.responseDecoder.buffer(), valueOffset, valueLength);
        return buf;
    }

    public long getKey() {
        return this.responseDecoder.key();
    }

    public int getPartitionId() {
        return this.responseDecoder.partitionId();
    }

    public ValueType getValueType() {
        return this.responseDecoder.valueType();
    }

    public Intent getIntent() {
        return Intent.fromProtocolValue((ValueType)this.responseDecoder.valueType(), (short)this.responseDecoder.intent());
    }

    public RecordType getRecordType() {
        return this.responseDecoder.recordType();
    }

    public RejectionType getRejectionType() {
        return this.responseDecoder.rejectionType();
    }

    public String getRejectionReason() {
        return this.rejectionReason;
    }

    public void wrap(DirectBuffer responseBuffer, int offset, int length) {
        this.messageHeaderDecoder.wrap(responseBuffer, offset);
        if (this.messageHeaderDecoder.templateId() != this.responseDecoder.sbeTemplateId()) {
            if (this.messageHeaderDecoder.templateId() == 10) {
                this.errorResponse.wrap(responseBuffer, offset + this.messageHeaderDecoder.encodedLength(), length);
                throw new RuntimeException("Unexpected error response from broker: " + String.valueOf(this.errorResponse.getErrorCode()) + " - " + this.errorResponse.getErrorData());
            }
            throw new RuntimeException("Unexpected response from broker. Template id " + this.messageHeaderDecoder.templateId());
        }
        this.responseDecoder.wrap(responseBuffer, offset + this.messageHeaderDecoder.encodedLength(), this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
        this.valueLengthOffset = this.responseDecoder.limit();
        int valueLength = this.responseDecoder.valueLength();
        int valueOffset = this.valueLengthOffset + ExecuteCommandResponseDecoder.valueHeaderLength();
        this.responseBuffer.wrap(responseBuffer, valueOffset, valueLength);
        try (DirectBufferInputStream is = new DirectBufferInputStream(responseBuffer, valueOffset, valueLength);){
            this.value = this.msgPackHelper.readMsgPack((InputStream)is);
        }
        catch (IOException e) {
            LangUtil.rethrowUnchecked((Throwable)e);
        }
        this.responseDecoder.limit(valueOffset + valueLength);
        this.rejectionReason = this.responseDecoder.rejectionReason();
    }

    public <T extends BufferReader> T readInto(T record) {
        record.wrap(this.responseBuffer, 0, this.responseBuffer.capacity());
        return record;
    }
}

