/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.test.broker.protocol.commandapi;

import io.camunda.zeebe.protocol.impl.encoding.AuthInfo;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.test.broker.protocol.MsgPackHelper;
import io.camunda.zeebe.test.broker.protocol.commandapi.ExecuteCommandRequest;
import io.camunda.zeebe.test.broker.protocol.commandapi.ExecuteCommandResponse;
import io.camunda.zeebe.test.util.collection.MapBuilder;
import io.camunda.zeebe.transport.ClientTransport;
import io.camunda.zeebe.util.buffer.BufferWriter;
import java.util.Map;

public final class ExecuteCommandRequestBuilder {
    protected final ExecuteCommandRequest request;

    public ExecuteCommandRequestBuilder(ClientTransport output, String targetAddress, MsgPackHelper msgPackHelper) {
        this.request = new ExecuteCommandRequest(output, targetAddress, msgPackHelper);
    }

    public ExecuteCommandResponse sendAndAwait() {
        return this.send().await();
    }

    public ExecuteCommandRequest send() {
        return this.request.send();
    }

    public ExecuteCommandRequestBuilder partitionId(int partitionId) {
        this.request.partitionId(partitionId);
        return this;
    }

    public ExecuteCommandRequestBuilder key(long key) {
        this.request.key(key);
        return this;
    }

    public ExecuteCommandRequestBuilder type(ValueType valueType, Intent intent) {
        this.request.valueType(valueType);
        this.request.intent(intent);
        return this;
    }

    public ExecuteCommandRequestBuilder intent(Intent intent) {
        this.request.intent(intent);
        return this;
    }

    public ExecuteCommandRequestBuilder authorization(AuthInfo authorization) {
        this.request.setAuthorization(authorization);
        return this;
    }

    public ExecuteCommandRequestBuilder command(Map<String, Object> command) {
        this.request.command(command);
        return this;
    }

    public ExecuteCommandRequestBuilder command(BufferWriter command) {
        this.request.command(command);
        return this;
    }

    public MapBuilder<ExecuteCommandRequestBuilder> command() {
        MapBuilder mapBuilder = new MapBuilder((Object)this, this::command);
        return mapBuilder;
    }
}

