/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.test.broker.protocol.commandapi;

import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.model.bpmn.builder.ServiceTaskBuilder;
import io.camunda.zeebe.msgpack.value.LongValue;
import io.camunda.zeebe.protocol.impl.record.value.deployment.DeploymentRecord;
import io.camunda.zeebe.protocol.impl.record.value.deployment.DeploymentResource;
import io.camunda.zeebe.protocol.impl.record.value.deployment.ProcessMetadata;
import io.camunda.zeebe.protocol.impl.record.value.job.JobBatchRecord;
import io.camunda.zeebe.protocol.impl.record.value.job.JobRecord;
import io.camunda.zeebe.protocol.impl.record.value.message.MessageRecord;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceCreationRecord;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.RecordType;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.DeploymentIntent;
import io.camunda.zeebe.protocol.record.intent.IncidentIntent;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.JobBatchIntent;
import io.camunda.zeebe.protocol.record.intent.JobIntent;
import io.camunda.zeebe.protocol.record.intent.MessageIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceCreationIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.intent.TimerIntent;
import io.camunda.zeebe.protocol.record.intent.VariableDocumentIntent;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import io.camunda.zeebe.protocol.record.value.DeploymentRecordValue;
import io.camunda.zeebe.protocol.record.value.IncidentRecordValue;
import io.camunda.zeebe.protocol.record.value.JobRecordValue;
import io.camunda.zeebe.protocol.record.value.MessageRecordValue;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRecordValue;
import io.camunda.zeebe.protocol.record.value.TimerRecordValue;
import io.camunda.zeebe.protocol.record.value.VariableDocumentUpdateSemantic;
import io.camunda.zeebe.test.broker.protocol.commandapi.CommandApiRule;
import io.camunda.zeebe.test.broker.protocol.commandapi.ExecuteCommandRequestBuilder;
import io.camunda.zeebe.test.broker.protocol.commandapi.ExecuteCommandResponse;
import io.camunda.zeebe.test.util.MsgPackUtil;
import io.camunda.zeebe.test.util.TestUtil;
import io.camunda.zeebe.test.util.record.DeploymentRecordStream;
import io.camunda.zeebe.test.util.record.IncidentRecordStream;
import io.camunda.zeebe.test.util.record.JobBatchRecordStream;
import io.camunda.zeebe.test.util.record.JobRecordStream;
import io.camunda.zeebe.test.util.record.MessageRecordStream;
import io.camunda.zeebe.test.util.record.MessageSubscriptionRecordStream;
import io.camunda.zeebe.test.util.record.ProcessInstanceRecordStream;
import io.camunda.zeebe.test.util.record.ProcessMessageSubscriptionRecordStream;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import io.camunda.zeebe.test.util.record.TimerRecordStream;
import io.camunda.zeebe.util.buffer.BufferUtil;
import io.camunda.zeebe.util.buffer.BufferWriter;
import io.camunda.zeebe.util.collection.Tuple;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.agrona.DirectBuffer;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IteratorAssert;

public final class PartitionTestClient {
    public static final String PROP_PROCESS_RESOURCES = "resources";
    public static final String PROP_PROCESS_VERSION = "version";
    public static final String PROP_PROCESS_VARIABLES = "variable";
    public static final String PROP_PROCESS_INSTANCE_KEY = "processInstanceKey";
    public static final String PROP_PROCESS_KEY = "processDefinitionKey";
    private final CommandApiRule apiRule;
    private final int partitionId;

    public PartitionTestClient(CommandApiRule apiRule, int partitionId) {
        this.apiRule = apiRule;
        this.partitionId = partitionId;
    }

    public long deploy(BpmnModelInstance process) {
        ExecuteCommandResponse response = this.deployWithResponse(process);
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)response.getRecordType()).withFailMessage("Deployment failed: %s", new Object[]{response.getRejectionReason()})).isEqualTo((Object)RecordType.EVENT);
        long key = response.getKey();
        TestUtil.waitUntil(() -> ((DeploymentRecordStream)((DeploymentRecordStream)RecordingExporter.deploymentRecords((DeploymentIntent)DeploymentIntent.CREATED).withPartitionId(this.partitionId)).withRecordKey(key)).exists());
        return key;
    }

    public ExecuteCommandResponse deployWithResponse(byte[] resource) {
        return this.deployWithResponse(resource, "process.bpmn");
    }

    public ExecuteCommandResponse deployWithResponse(BpmnModelInstance process) {
        return this.deployWithResponse(process, "process.bpmn");
    }

    public ExecuteCommandResponse deployWithResponse(BpmnModelInstance process, String resourceName) {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        Bpmn.writeModelToStream((OutputStream)outStream, (BpmnModelInstance)process);
        byte[] resource = outStream.toByteArray();
        return this.deployWithResponse(resource, resourceName);
    }

    public ExecuteCommandResponse deployWithResponse(byte[] resource, String resourceName) {
        HashMap<String, Object> deploymentResource = new HashMap<String, Object>();
        deploymentResource.put("resource", resource);
        deploymentResource.put("resourceName", resourceName);
        ExecuteCommandResponse commandResponse = ((ExecuteCommandRequestBuilder)this.apiRule.createCmdRequest().partitionId(1).type(ValueType.DEPLOYMENT, (Intent)DeploymentIntent.CREATE).command().put(PROP_PROCESS_RESOURCES, Collections.singletonList(deploymentResource)).done()).sendAndAwait();
        return commandResponse;
    }

    public ProcessMetadata deployProcess(BpmnModelInstance process) {
        DeploymentRecord request = new DeploymentRecord();
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        Bpmn.writeModelToStream((OutputStream)outStream, (BpmnModelInstance)process);
        ((DeploymentResource)request.resources().add()).setResource(outStream.toByteArray()).setResourceName("process.bpmn");
        DeploymentRecord response = this.deploy(request);
        Iterator iterator = response.processesMetadata().iterator();
        ((IteratorAssert)Assertions.assertThat((Iterator)iterator).as("Expected at least one deployed process, but none returned", new Object[0])).hasNext();
        return (ProcessMetadata)iterator.next();
    }

    public DeploymentRecord deploy(Function<DeploymentRecord, DeploymentRecord> transformer) {
        return this.deploy(transformer.apply(new DeploymentRecord()));
    }

    public DeploymentRecord deploy(DeploymentRecord request) {
        ExecuteCommandResponse response = this.executeCommandRequest(ValueType.DEPLOYMENT, (Intent)DeploymentIntent.CREATE, (BufferWriter)request);
        Assertions.assertThat((Comparable)response.getRecordType()).isEqualTo((Object)RecordType.EVENT);
        Assertions.assertThat((Object)response.getIntent()).isEqualTo((Object)DeploymentIntent.CREATED);
        return response.readInto(new DeploymentRecord());
    }

    public ProcessInstanceCreationRecord createProcessInstance(Function<ProcessInstanceCreationRecord, ProcessInstanceCreationRecord> mapper) {
        return this.createProcessInstance(mapper.apply(new ProcessInstanceCreationRecord()));
    }

    public ProcessInstanceCreationRecord createProcessInstance(ProcessInstanceCreationRecord record) {
        ExecuteCommandResponse response = this.executeCommandRequest(ValueType.PROCESS_INSTANCE_CREATION, (Intent)ProcessInstanceCreationIntent.CREATE, (BufferWriter)record);
        Assertions.assertThat((Comparable)response.getRecordType()).isEqualTo((Object)RecordType.EVENT);
        Assertions.assertThat((Object)response.getIntent()).isEqualTo((Object)ProcessInstanceCreationIntent.CREATED);
        return response.readInto(new ProcessInstanceCreationRecord());
    }

    public ExecuteCommandResponse executeCommandRequest(ValueType valueType, Intent intent, BufferWriter command) {
        return this.executeCommandRequest(valueType, intent, command, -1L);
    }

    public ExecuteCommandResponse executeCommandRequest(ValueType valueType, Intent intent, BufferWriter command, long key) {
        return this.apiRule.createCmdRequest().partitionId(this.partitionId).key(key).type(valueType, intent).command(command).sendAndAwait();
    }

    public ExecuteCommandResponse cancelProcessInstance(long key) {
        return ((ExecuteCommandRequestBuilder)this.apiRule.createCmdRequest().partitionId(this.partitionId).type(ValueType.PROCESS_INSTANCE, (Intent)ProcessInstanceIntent.CANCEL).key(key).command().done()).sendAndAwait();
    }

    public void updateVariables(long scopeKey, Map<String, Object> document) {
        this.updateVariables(scopeKey, VariableDocumentUpdateSemantic.PROPAGATE, document);
    }

    public void updateVariables(long scopeKey, VariableDocumentUpdateSemantic updateSemantics, Map<String, Object> document) {
        ExecuteCommandResponse response = ((ExecuteCommandRequestBuilder)this.apiRule.createCmdRequest().type(ValueType.VARIABLE_DOCUMENT, (Intent)VariableDocumentIntent.UPDATE).command().put("scopeKey", (Object)scopeKey).put("updateSemantics", (Object)updateSemantics).put("document", (Object)MsgPackUtil.asMsgPack(document).byteArray()).done()).sendAndAwait();
        Assertions.assertThat((Comparable)response.getRecordType()).isEqualTo((Object)RecordType.EVENT);
        Assertions.assertThat((Object)response.getIntent()).isEqualTo((Object)VariableDocumentIntent.UPDATED);
    }

    public long createJob(String type) {
        return this.createJob(type, b -> {}, "{}");
    }

    public long createJob(String type, Consumer<ServiceTaskBuilder> consumer, String variables) {
        this.deploy(Bpmn.createExecutableProcess((String)"process").startEvent().serviceTask("task", b -> {
            ((ServiceTaskBuilder)b.zeebeJobType(type)).zeebeJobRetries("3");
            consumer.accept((ServiceTaskBuilder)b);
        }).done());
        long processInstance = this.createProcessInstance((ProcessInstanceCreationRecord r) -> r.setBpmnProcessId("process").setVariables(MsgPackUtil.asMsgPack((String)variables))).getProcessInstanceKey();
        return ((Record)((JobRecordStream)RecordingExporter.jobRecords((JobIntent)JobIntent.CREATED).withType(type).filter(j -> ((JobRecordValue)j.getValue()).getProcessInstanceKey() == processInstance)).getFirst()).getKey();
    }

    public JobRecord activateAndCompleteFirstJob(String jobType, Predicate<JobRecord> filter) {
        Tuple<Long, JobRecord> pair = this.activateJob(jobType, filter);
        return this.completeJob((long)((Long)pair.getLeft()), (JobRecord)pair.getRight());
    }

    public Tuple<Long, JobRecord> activateJob(String jobType, Predicate<JobRecord> filter) {
        JobBatchRecord request = new JobBatchRecord().setType(jobType).setMaxJobsToActivate(1).setTimeout(1000L).setWorker("partition-" + this.partitionId + "-" + jobType);
        return (Tuple)TestUtil.doRepeatedly(() -> {
            JobRecord job;
            JobBatchRecord response = this.activateJobBatch(request);
            if (response.getMaxJobsToActivate() > 0 && filter.test(job = (JobRecord)response.jobs().iterator().next())) {
                return new Tuple((Object)((LongValue)response.jobKeys().iterator().next()).getValue(), (Object)job);
            }
            return null;
        }).until(Objects::nonNull);
    }

    public JobRecord completeJob(long jobKey, Function<JobRecord, JobRecord> transformer) {
        return this.completeJob(jobKey, transformer.apply(new JobRecord()));
    }

    public JobRecord completeJob(long jobKey, JobRecord request) {
        ExecuteCommandResponse response = this.executeCommandRequest(ValueType.JOB, (Intent)JobIntent.COMPLETE, (BufferWriter)request, jobKey);
        Assertions.assertThat((Comparable)response.getRecordType()).isEqualTo((Object)RecordType.EVENT);
        Assertions.assertThat((Object)response.getIntent()).isEqualTo((Object)JobIntent.COMPLETED);
        return response.readInto(new JobRecord());
    }

    public JobBatchRecord activateJobBatch(Function<JobBatchRecord, JobBatchRecord> transformer) {
        return this.activateJobBatch(transformer.apply(new JobBatchRecord()));
    }

    public JobBatchRecord activateJobBatch(JobBatchRecord request) {
        ExecuteCommandResponse response = this.executeCommandRequest(ValueType.JOB_BATCH, (Intent)JobBatchIntent.ACTIVATE, (BufferWriter)request);
        Assertions.assertThat((Comparable)response.getRecordType()).isEqualTo((Object)RecordType.EVENT);
        Assertions.assertThat((Object)response.getIntent()).isEqualTo((Object)JobBatchIntent.ACTIVATED);
        return response.readInto(new JobBatchRecord());
    }

    public void completeJobOfType(long processInstanceKey, String jobType) {
        this.completeJob(jobType, MsgPackUtil.asMsgPackReturnArray((String)"{}"), r -> ((JobRecordValue)r.getValue()).getProcessInstanceKey() == processInstanceKey);
    }

    public void completeJobOfType(String jobType) {
        this.completeJobOfType(jobType, "{}");
    }

    public void completeJobOfType(String jobType, byte[] variables) {
        this.completeJob(jobType, variables, e -> true);
    }

    public void completeJobOfType(String jobType, String jsonVariables) {
        this.completeJob(jobType, MsgPackUtil.asMsgPackReturnArray((String)jsonVariables), e -> true);
    }

    public ExecuteCommandResponse completeJob(long key, String variables) {
        return this.completeJob(key, MsgPackUtil.asMsgPackReturnArray((String)variables));
    }

    public ExecuteCommandResponse completeJob(long key, byte[] variables) {
        return ((ExecuteCommandRequestBuilder)this.apiRule.createCmdRequest().type(ValueType.JOB, (Intent)JobIntent.COMPLETE).key(key).command().put("variables", (Object)variables).done()).sendAndAwait();
    }

    public void completeJob(String jobType, byte[] variables, Predicate<Record<JobRecordValue>> jobEventFilter) {
        this.apiRule.activateJobs(this.partitionId, jobType, 1000L).await();
        Record jobEvent = (Record)((JobRecordStream)((JobRecordStream)this.receiveJobs().withIntent((Intent)JobIntent.CREATED)).withType(jobType).filter(jobEventFilter)).findFirst().orElseThrow(() -> new AssertionError((Object)"Expected job to be created but not found."));
        ExecuteCommandResponse response = this.completeJob(jobEvent.getKey(), variables);
        Assertions.assertThat((Comparable)response.getRecordType()).isEqualTo((Object)RecordType.EVENT);
        Assertions.assertThat((Object)response.getIntent()).isEqualTo((Object)JobIntent.COMPLETED);
    }

    public ExecuteCommandResponse failJob(long key, int retries) {
        return ((ExecuteCommandRequestBuilder)this.apiRule.createCmdRequest().type(ValueType.JOB, (Intent)JobIntent.FAIL).key(key).command().put("retries", (Object)retries).done()).sendAndAwait();
    }

    public ExecuteCommandResponse failJobWithMessage(long key, int retries, String errorMessage) {
        return ((ExecuteCommandRequestBuilder)this.apiRule.createCmdRequest().type(ValueType.JOB, (Intent)JobIntent.FAIL).key(key).command().put("retries", (Object)retries).put("errorMessage", (Object)errorMessage).done()).sendAndAwait();
    }

    public ExecuteCommandResponse createJobIncidentWithJobErrorMessage(long key, String errorMessage) {
        return this.failJobWithMessage(key, 0, errorMessage);
    }

    public ExecuteCommandResponse updateJobRetries(long key, int retries) {
        return ((ExecuteCommandRequestBuilder)this.apiRule.createCmdRequest().type(ValueType.JOB, (Intent)JobIntent.UPDATE_RETRIES).key(key).command().put("retries", (Object)retries).done()).sendAndAwait();
    }

    public MessageRecord publishMessage(Function<MessageRecord, MessageRecord> transformer) {
        return this.publishMessage(transformer.apply(new MessageRecord()));
    }

    public MessageRecord publishMessage(MessageRecord request) {
        ExecuteCommandResponse response = this.executeCommandRequest(ValueType.MESSAGE, (Intent)MessageIntent.PUBLISH, (BufferWriter)request);
        Assertions.assertThat((Comparable)response.getRecordType()).isEqualTo((Object)RecordType.EVENT);
        Assertions.assertThat((Object)response.getIntent()).isEqualTo((Object)MessageIntent.PUBLISHED);
        return response.readInto(new MessageRecord());
    }

    public ExecuteCommandResponse publishMessage(String messageName, String correlationKey) {
        return this.publishMessage(messageName, correlationKey, new byte[0]);
    }

    public ExecuteCommandResponse publishMessage(String messageName, String correlationKey, DirectBuffer variables) {
        return this.publishMessage(messageName, correlationKey, BufferUtil.bufferAsArray((DirectBuffer)variables));
    }

    public ExecuteCommandResponse publishMessage(String messageName, String correlationKey, String variables) {
        return this.publishMessage(messageName, correlationKey, MsgPackUtil.asMsgPackReturnArray((String)variables));
    }

    public ExecuteCommandResponse publishMessage(String messageName, String correlationKey, DirectBuffer variables, long ttl) {
        return this.publishMessage(messageName, correlationKey, BufferUtil.bufferAsArray((DirectBuffer)variables), ttl);
    }

    public ExecuteCommandResponse publishMessage(String messageName, String correlationKey, byte[] variables) {
        return this.publishMessage(messageName, correlationKey, variables, Duration.ofHours(1L).toMillis());
    }

    public ExecuteCommandResponse publishMessage(String messageName, String correlationKey, byte[] variables, long ttl) {
        return ((ExecuteCommandRequestBuilder)this.apiRule.createCmdRequest().partitionId(this.partitionId).type(ValueType.MESSAGE, (Intent)MessageIntent.PUBLISH).command().put("name", (Object)messageName).put("correlationKey", (Object)correlationKey).put("timeToLive", (Object)ttl).put("variables", (Object)variables).done()).sendAndAwait();
    }

    public IncidentRecordStream receiveIncidents() {
        return (IncidentRecordStream)RecordingExporter.incidentRecords().withPartitionId(this.partitionId);
    }

    public Record<IncidentRecordValue> receiveFirstIncidentEvent(IncidentIntent intent) {
        return (Record)((IncidentRecordStream)this.receiveIncidents().withIntent((Intent)intent)).getFirst();
    }

    public Record<IncidentRecordValue> receiveFirstIncidentEvent(long processInstanceKey, Intent intent) {
        return (Record)((IncidentRecordStream)this.receiveIncidents().withIntent(intent)).withProcessInstanceKey(processInstanceKey).getFirst();
    }

    public Record<IncidentRecordValue> receiveFirstIncidentCommand(IncidentIntent intent) {
        return (Record)((IncidentRecordStream)((IncidentRecordStream)this.receiveIncidents().withIntent((Intent)intent)).onlyCommands()).getFirst();
    }

    public ExecuteCommandResponse resolveIncident(long incidentKey) {
        return ((ExecuteCommandRequestBuilder)this.apiRule.createCmdRequest().partitionId(this.partitionId).type(ValueType.INCIDENT, (Intent)IncidentIntent.RESOLVE).key(incidentKey).command().done()).sendAndAwait();
    }

    public DeploymentRecordStream receiveDeployments() {
        return (DeploymentRecordStream)RecordingExporter.deploymentRecords().withPartitionId(this.partitionId);
    }

    public Record<DeploymentRecordValue> receiveFirstDeploymentEvent(DeploymentIntent intent, long deploymentKey) {
        return (Record)((DeploymentRecordStream)((DeploymentRecordStream)this.receiveDeployments().withIntent((Intent)intent)).withRecordKey(deploymentKey)).getFirst();
    }

    public ProcessInstanceRecordStream receiveProcessInstances() {
        return (ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().withPartitionId(this.partitionId);
    }

    public Record<ProcessInstanceRecordValue> receiveFirstProcessInstanceCommand(ProcessInstanceIntent intent) {
        return (Record)((ProcessInstanceRecordStream)((ProcessInstanceRecordStream)this.receiveProcessInstances().withIntent((Intent)intent)).onlyCommands()).getFirst();
    }

    public Record<ProcessInstanceRecordValue> receiveFirstProcessInstanceEvent(ProcessInstanceIntent intent) {
        return (Record)((ProcessInstanceRecordStream)this.receiveProcessInstances().withIntent((Intent)intent)).getFirst();
    }

    public Record<ProcessInstanceRecordValue> receiveFirstProcessInstanceEvent(ProcessInstanceIntent intent, BpmnElementType elementType) {
        return (Record)((ProcessInstanceRecordStream)this.receiveProcessInstances().withIntent((Intent)intent)).withElementType(elementType).getFirst();
    }

    public Record<ProcessInstanceRecordValue> receiveFirstProcessInstanceEvent(long processInstanceKey, String elementId, Intent intent) {
        return (Record)((ProcessInstanceRecordStream)this.receiveProcessInstances().withIntent(intent)).withProcessInstanceKey(processInstanceKey).withElementId(elementId).getFirst();
    }

    public Record<ProcessInstanceRecordValue> receiveFirstProcessInstanceEvent(long processInstanceKey, Intent intent) {
        return (Record)((ProcessInstanceRecordStream)this.receiveProcessInstances().withIntent(intent)).withProcessInstanceKey(processInstanceKey).getFirst();
    }

    public Record<ProcessInstanceRecordValue> receiveFirstProcessInstanceEvent(long processInstanceKey, Intent intent, BpmnElementType elementType) {
        return (Record)((ProcessInstanceRecordStream)this.receiveProcessInstances().withIntent(intent)).withProcessInstanceKey(processInstanceKey).withElementType(elementType).getFirst();
    }

    public Record<ProcessInstanceRecordValue> receiveElementInState(String elementId, ProcessInstanceIntent intent) {
        return (Record)((ProcessInstanceRecordStream)this.receiveProcessInstances().withIntent((Intent)intent)).withElementId(elementId).getFirst();
    }

    public Record<ProcessInstanceRecordValue> receiveElementInState(long processInstanceKey, String elementId, ProcessInstanceIntent intent) {
        return this.receiveFirstProcessInstanceEvent(processInstanceKey, elementId, (Intent)intent);
    }

    public List<Record<ProcessInstanceRecordValue>> receiveElementInstancesInState(Intent intent, int expectedNumber) {
        return (List)((ProcessInstanceRecordStream)((ProcessInstanceRecordStream)this.receiveProcessInstances().withIntent(intent)).limit((long)expectedNumber)).collect(Collectors.toList());
    }

    public List<Record<ProcessInstanceRecordValue>> receiveElementInstancesInState(Intent intent, BpmnElementType elementType, int expectedNumber) {
        return (List)((ProcessInstanceRecordStream)((ProcessInstanceRecordStream)this.receiveProcessInstances().withIntent(intent)).withElementType(elementType).limit((long)expectedNumber)).collect(Collectors.toList());
    }

    public JobRecordStream receiveJobs() {
        return (JobRecordStream)RecordingExporter.jobRecords().withPartitionId(this.partitionId);
    }

    public Record<JobRecordValue> receiveFirstJobEvent(JobIntent intent) {
        return (Record)((JobRecordStream)this.receiveJobs().withIntent((Intent)intent)).getFirst();
    }

    public Record<JobRecordValue> receiveFirstJobCommand(JobIntent intent) {
        return (Record)((JobRecordStream)((JobRecordStream)this.receiveJobs().onlyCommands()).withIntent((Intent)intent)).getFirst();
    }

    public JobBatchRecordStream receiveJobBatchs() {
        return (JobBatchRecordStream)RecordingExporter.jobBatchRecords().withPartitionId(this.partitionId);
    }

    public JobBatchRecordStream receiveFirstJobBatchCommands() {
        return (JobBatchRecordStream)((JobBatchRecordStream)RecordingExporter.jobBatchRecords().withPartitionId(this.partitionId)).onlyCommands();
    }

    public MessageRecordStream receiveMessages() {
        return (MessageRecordStream)RecordingExporter.messageRecords().withPartitionId(this.partitionId);
    }

    public Record<MessageRecordValue> receiveFirstMessageEvent(MessageIntent intent) {
        return (Record)((MessageRecordStream)this.receiveMessages().withIntent((Intent)intent)).getFirst();
    }

    public MessageSubscriptionRecordStream receiveMessageSubscriptions() {
        return (MessageSubscriptionRecordStream)RecordingExporter.messageSubscriptionRecords().withPartitionId(this.partitionId);
    }

    public ProcessMessageSubscriptionRecordStream receiveProcessMessageSubscriptions() {
        return (ProcessMessageSubscriptionRecordStream)RecordingExporter.processMessageSubscriptionRecords().withPartitionId(this.partitionId);
    }

    public TimerRecordStream receiveTimerRecords() {
        return (TimerRecordStream)RecordingExporter.timerRecords().withPartitionId(this.partitionId);
    }

    public Record<TimerRecordValue> receiveTimerRecord(String handlerNodeId, TimerIntent intent) {
        return (Record)((TimerRecordStream)this.receiveTimerRecords().withIntent((Intent)intent)).withHandlerNodeId(handlerNodeId).getFirst();
    }

    public Record<TimerRecordValue> receiveTimerRecord(DirectBuffer handlerNodeId, TimerIntent intent) {
        return this.receiveTimerRecord(BufferUtil.bufferAsString((DirectBuffer)handlerNodeId), intent);
    }
}

