/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.test.broker.protocol;

import com.fasterxml.jackson.core.StreamReadConstraints;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.msgpack.jackson.dataformat.MessagePackFactory;

public final class MsgPackHelper {
    private final ObjectMapper objectMapper = new ObjectMapper(new MessagePackFactory().setStreamReadConstraints(StreamReadConstraints.builder().maxNumberLength(Integer.MAX_VALUE).maxNestingDepth(Integer.MAX_VALUE).maxStringLength(Integer.MAX_VALUE).build()));

    public MsgPackHelper() {
        this.objectMapper.configure(DeserializationFeature.USE_LONG_FOR_INTS, true);
    }

    public Map<String, Object> readMsgPack(InputStream is) {
        try {
            return (Map)this.objectMapper.readValue(is, Map.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public byte[] encodeAsMsgPack(Object command) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            this.objectMapper.writer().writeValue((OutputStream)byteArrayOutputStream, command);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return byteArrayOutputStream.toByteArray();
    }
}

