/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.test.broker.protocol.brokerapi;

import io.camunda.zeebe.protocol.record.ErrorCode;
import io.camunda.zeebe.test.broker.protocol.MsgPackHelper;
import io.camunda.zeebe.test.broker.protocol.brokerapi.ErrorResponseWriter;
import io.camunda.zeebe.test.broker.protocol.brokerapi.MessageBuilder;
import io.camunda.zeebe.test.broker.protocol.brokerapi.ResponseController;
import java.util.function.Consumer;

public final class ErrorResponseBuilder<R> {
    protected final Consumer<MessageBuilder<R>> registrationFunction;
    protected final ErrorResponseWriter<R> commandResponseWriter;

    public ErrorResponseBuilder(Consumer<MessageBuilder<R>> registrationFunction, MsgPackHelper msgPackConverter) {
        this.registrationFunction = registrationFunction;
        this.commandResponseWriter = new ErrorResponseWriter(msgPackConverter);
    }

    public ErrorResponseBuilder<R> errorCode(ErrorCode errorCode) {
        this.commandResponseWriter.setErrorCode(errorCode);
        return this;
    }

    public ErrorResponseBuilder<R> errorData(String errorData) {
        this.commandResponseWriter.setErrorData(errorData);
        return this;
    }

    public void register() {
        this.registrationFunction.accept(this.commandResponseWriter);
    }

    public ResponseController registerControlled() {
        ResponseController controller = new ResponseController();
        this.commandResponseWriter.beforeResponse(controller::waitForNextJoin);
        this.register();
        return controller;
    }
}

