/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.test.broker.protocol.brokerapi;

import io.atomix.cluster.AtomixCluster;
import io.camunda.zeebe.protocol.impl.Loggers;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.scheduler.ActorScheduler;
import io.camunda.zeebe.scheduler.ActorSchedulingService;
import io.camunda.zeebe.scheduler.clock.ActorClock;
import io.camunda.zeebe.scheduler.clock.ControlledActorClock;
import io.camunda.zeebe.test.broker.protocol.MsgPackHelper;
import io.camunda.zeebe.test.broker.protocol.brokerapi.ExecuteCommandRequest;
import io.camunda.zeebe.test.broker.protocol.brokerapi.ExecuteCommandResponseTypeBuilder;
import io.camunda.zeebe.test.broker.protocol.brokerapi.StubRequestHandler;
import io.camunda.zeebe.test.util.socket.SocketUtil;
import io.camunda.zeebe.transport.RequestHandler;
import io.camunda.zeebe.transport.RequestType;
import io.camunda.zeebe.transport.ServerTransport;
import io.camunda.zeebe.transport.TransportFactory;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.function.Predicate;

public final class StubBroker
implements AutoCloseable {
    private final int nodeId;
    private final InetSocketAddress socketAddress;
    private ActorScheduler scheduler;
    private MsgPackHelper msgPackHelper;
    private final ControlledActorClock clock = new ControlledActorClock();
    private StubRequestHandler channelHandler;
    private AtomixCluster cluster;
    private int currentStubPort;
    private String currentStubHost;
    private ServerTransport serverTransport;

    public StubBroker() {
        this.nodeId = 0;
        this.socketAddress = SocketUtil.getNextAddress();
    }

    public StubBroker start() {
        this.msgPackHelper = new MsgPackHelper();
        int numThreads = 2;
        this.scheduler = ActorScheduler.newActorScheduler().setCpuBoundActorThreadCount(2).setActorClock((ActorClock)this.clock).build();
        this.scheduler.start();
        InetSocketAddress nextAddress = SocketUtil.getNextAddress();
        this.currentStubHost = nextAddress.getHostName();
        this.currentStubPort = nextAddress.getPort();
        this.cluster = AtomixCluster.builder().withPort(this.currentStubPort).withMemberId("0").withClusterId("cluster").build();
        this.cluster.start().join();
        TransportFactory transportFactory = new TransportFactory((ActorSchedulingService)this.scheduler);
        this.serverTransport = transportFactory.createServerTransport(this.nodeId, this.cluster.getMessagingService());
        this.channelHandler = new StubRequestHandler(this.msgPackHelper);
        this.serverTransport.subscribe(1, RequestType.COMMAND, (RequestHandler)this.channelHandler);
        return this;
    }

    @Override
    public void close() {
        try {
            this.serverTransport.close();
        }
        catch (Exception e) {
            Loggers.PROTOCOL_LOGGER.error("Error on closing server transport.", (Throwable)e);
        }
        if (this.scheduler != null) {
            this.scheduler.stop();
        }
        this.cluster.stop().join();
    }

    public int getCurrentStubPort() {
        return this.currentStubPort;
    }

    public String getCurrentStubHost() {
        return this.currentStubHost;
    }

    private ExecuteCommandResponseTypeBuilder onExecuteCommandRequest(Predicate<ExecuteCommandRequest> activationFunction) {
        return new ExecuteCommandResponseTypeBuilder(this.channelHandler::addExecuteCommandRequestStub, activationFunction, this.msgPackHelper);
    }

    public ExecuteCommandResponseTypeBuilder onExecuteCommandRequest(ValueType eventType, Intent intent) {
        return this.onExecuteCommandRequest(ecr -> ecr.valueType() == eventType && ecr.intent() == intent);
    }

    public List<ExecuteCommandRequest> getReceivedCommandRequests() {
        return this.channelHandler.getReceivedCommandRequests();
    }

    public InetSocketAddress getSocketAddress() {
        return this.socketAddress;
    }

    public int getNodeId() {
        return this.nodeId;
    }

    public ControlledActorClock getClock() {
        return this.clock;
    }
}

