/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.test.broker.protocol.brokerapi;

import io.camunda.zeebe.protocol.record.RecordType;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.test.broker.protocol.MsgPackHelper;
import io.camunda.zeebe.test.broker.protocol.brokerapi.ExecuteCommandRequest;
import io.camunda.zeebe.test.broker.protocol.brokerapi.ExecuteCommandResponseWriter;
import io.camunda.zeebe.test.broker.protocol.brokerapi.MessageBuilder;
import io.camunda.zeebe.test.broker.protocol.brokerapi.ResponseController;
import io.camunda.zeebe.test.util.collection.MapFactoryBuilder;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;

public final class ExecuteCommandResponseBuilder {
    protected final Consumer<MessageBuilder<ExecuteCommandRequest>> registrationFunction;
    protected final ExecuteCommandResponseWriter commandResponseWriter;

    public ExecuteCommandResponseBuilder(Consumer<MessageBuilder<ExecuteCommandRequest>> registrationFunction, MsgPackHelper msgPackConverter) {
        this.registrationFunction = registrationFunction;
        this.commandResponseWriter = new ExecuteCommandResponseWriter(msgPackConverter);
        this.partitionId(ExecuteCommandRequest::partitionId);
    }

    public ExecuteCommandResponseBuilder partitionId(int partitionId) {
        return this.partitionId(r -> partitionId);
    }

    public ExecuteCommandResponseBuilder partitionId(Function<ExecuteCommandRequest, Integer> partitionIdFunction) {
        this.commandResponseWriter.setPartitionIdFunction(partitionIdFunction);
        return this;
    }

    public ExecuteCommandResponseBuilder key(long l) {
        return this.key(r -> l);
    }

    public ExecuteCommandResponseBuilder key(Function<ExecuteCommandRequest, Long> keyFunction) {
        this.commandResponseWriter.setKeyFunction(keyFunction);
        return this;
    }

    public ExecuteCommandResponseBuilder value(Map<String, Object> map) {
        this.commandResponseWriter.setEventFunction(re -> map);
        return this;
    }

    public ExecuteCommandResponseBuilder rejection(RejectionType rejectionType, String reason) {
        this.commandResponseWriter.setRecordType(RecordType.COMMAND_REJECTION);
        this.commandResponseWriter.setIntentFunction(r -> r.intent());
        this.commandResponseWriter.setRejectionType(rejectionType);
        this.commandResponseWriter.setRejectionReason(reason);
        return this;
    }

    public ExecuteCommandResponseBuilder rejection() {
        return this.rejection(RejectionType.NULL_VAL, "");
    }

    public ExecuteCommandResponseBuilder event() {
        this.commandResponseWriter.setRecordType(RecordType.EVENT);
        return this;
    }

    public ExecuteCommandResponseBuilder intent(Intent intent) {
        this.commandResponseWriter.setIntentFunction(r -> intent);
        return this;
    }

    public MapFactoryBuilder<ExecuteCommandRequest, ExecuteCommandResponseBuilder> value() {
        return new MapFactoryBuilder((Object)this, this.commandResponseWriter::setEventFunction);
    }

    public void register() {
        this.registrationFunction.accept(this.commandResponseWriter);
    }

    public ResponseController registerControlled() {
        ResponseController controller = new ResponseController();
        this.commandResponseWriter.beforeResponse(controller::waitForNextJoin);
        this.register();
        return controller;
    }
}

