/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.test.broker.protocol.brokerapi.data;

import io.camunda.zeebe.test.broker.protocol.brokerapi.data.BrokerPartitionState;
import java.net.InetSocketAddress;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;

public final class TopologyBroker {
    protected final int nodeId;
    protected final String host;
    protected final int port;
    private final Set<BrokerPartitionState> partitions = new LinkedHashSet<BrokerPartitionState>();
    private final InetSocketAddress address;

    public TopologyBroker(int nodeId, String host, int port) {
        this.nodeId = nodeId;
        this.host = host;
        this.port = port;
        this.address = new InetSocketAddress(host, port);
    }

    public int getNodeId() {
        return this.nodeId;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public Set<BrokerPartitionState> getPartitions() {
        return this.partitions;
    }

    public TopologyBroker addPartition(BrokerPartitionState brokerPartitionState) {
        this.partitions.add(brokerPartitionState);
        return this;
    }

    public int hashCode() {
        return Objects.hash(this.nodeId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TopologyBroker that = (TopologyBroker)o;
        return this.nodeId == that.nodeId;
    }

    public String toString() {
        return "TopologyBroker{partitions=" + this.partitions + ", nodeId=" + this.nodeId + ", host='" + this.host + "', port=" + this.port + ", address=" + this.address + "}";
    }
}

