/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.test.broker.protocol.brokerapi.data;

import io.camunda.zeebe.test.broker.protocol.brokerapi.StubBrokerRule;
import io.camunda.zeebe.test.broker.protocol.brokerapi.data.BrokerPartitionState;
import io.camunda.zeebe.test.broker.protocol.brokerapi.data.TopologyBroker;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class Topology {
    protected Map<Integer, TopologyBroker> brokers = new HashMap<Integer, TopologyBroker>();

    public Topology() {
    }

    public Topology(Topology other) {
        this.brokers = new HashMap<Integer, TopologyBroker>(other.brokers);
    }

    private TopologyBroker getBroker(int nodeId, InetSocketAddress brokerAddress) {
        TopologyBroker topologyBroker = this.brokers.get(nodeId);
        if (topologyBroker == null) {
            topologyBroker = new TopologyBroker(nodeId, brokerAddress.getHostName(), brokerAddress.getPort());
            this.brokers.put(nodeId, topologyBroker);
        }
        return topologyBroker;
    }

    public Topology addLeader(StubBrokerRule brokerRule, int partition) {
        return this.addLeader(brokerRule.getNodeId(), brokerRule.getSocketAddress(), partition);
    }

    public Topology addLeader(int nodeId, InetSocketAddress address, int partition) {
        this.getBroker(nodeId, address).addPartition(new BrokerPartitionState("LEADER", partition, 1));
        return this;
    }

    public Set<TopologyBroker> getBrokers() {
        return new HashSet<TopologyBroker>(this.brokers.values());
    }

    public String toString() {
        return "Topology{brokers=" + this.brokers.values() + "}";
    }
}

