/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.test.broker.protocol.brokerapi;

import io.camunda.zeebe.protocol.record.ExecuteCommandRequestDecoder;
import io.camunda.zeebe.protocol.record.MessageHeaderDecoder;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.test.broker.protocol.MsgPackHelper;
import io.camunda.zeebe.util.buffer.BufferReader;
import java.io.InputStream;
import java.util.Map;
import org.agrona.DirectBuffer;
import org.agrona.io.DirectBufferInputStream;

public final class ExecuteCommandRequest
implements BufferReader {
    protected final MessageHeaderDecoder headerDecoder = new MessageHeaderDecoder();
    protected final ExecuteCommandRequestDecoder bodyDecoder = new ExecuteCommandRequestDecoder();
    protected final MsgPackHelper msgPackHelper;
    protected Map<String, Object> command;

    public ExecuteCommandRequest(MsgPackHelper msgPackHelper) {
        this.msgPackHelper = msgPackHelper;
    }

    public long key() {
        return this.bodyDecoder.key();
    }

    public int partitionId() {
        return this.bodyDecoder.partitionId();
    }

    public ValueType valueType() {
        return this.bodyDecoder.valueType();
    }

    public Intent intent() {
        return Intent.fromProtocolValue((ValueType)this.valueType(), (short)this.bodyDecoder.intent());
    }

    public Map<String, Object> getCommand() {
        return this.command;
    }

    public void wrap(DirectBuffer buffer, int offset, int length) {
        this.headerDecoder.wrap(buffer, offset);
        this.bodyDecoder.wrap(buffer, offset + this.headerDecoder.encodedLength(), this.headerDecoder.blockLength(), this.headerDecoder.version());
        int commandLength = this.bodyDecoder.valueLength();
        int commandOffset = this.bodyDecoder.limit() + ExecuteCommandRequestDecoder.valueHeaderLength();
        this.command = this.msgPackHelper.readMsgPack((InputStream)new DirectBufferInputStream(buffer, commandOffset, commandLength));
    }
}

