/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.test.broker.protocol.brokerapi;

import io.camunda.zeebe.protocol.record.ErrorCode;
import io.camunda.zeebe.protocol.record.ErrorResponseEncoder;
import io.camunda.zeebe.protocol.record.MessageHeaderEncoder;
import io.camunda.zeebe.test.broker.protocol.MsgPackHelper;
import io.camunda.zeebe.test.broker.protocol.brokerapi.AbstractMessageBuilder;
import java.nio.charset.StandardCharsets;
import org.agrona.MutableDirectBuffer;

public final class ErrorResponseWriter<R>
extends AbstractMessageBuilder<R> {
    protected final MessageHeaderEncoder headerEncoder = new MessageHeaderEncoder();
    protected final ErrorResponseEncoder bodyEncoder = new ErrorResponseEncoder();
    protected final MsgPackHelper msgPackHelper;
    protected ErrorCode errorCode;
    protected byte[] errorData;

    public ErrorResponseWriter(MsgPackHelper msgPackHelper) {
        this.msgPackHelper = msgPackHelper;
    }

    public int getLength() {
        return 9 + ErrorResponseEncoder.errorDataHeaderLength() + this.errorData.length;
    }

    public void write(MutableDirectBuffer buffer, int offset) {
        this.headerEncoder.wrap(buffer, offset).blockLength(this.bodyEncoder.sbeBlockLength()).templateId(this.bodyEncoder.sbeTemplateId()).schemaId(this.bodyEncoder.sbeSchemaId()).version(this.bodyEncoder.sbeSchemaVersion());
        this.bodyEncoder.wrap(buffer, offset += this.headerEncoder.encodedLength()).errorCode(this.errorCode).putErrorData(this.errorData, 0, this.errorData.length);
    }

    @Override
    public void initializeFrom(R context) {
    }

    public void setErrorCode(ErrorCode errorCode) {
        this.errorCode = errorCode;
    }

    public void setErrorData(String errorData) {
        this.errorData = errorData.getBytes(StandardCharsets.UTF_8);
    }
}

