/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.test.broker.protocol.commandapi;

import io.camunda.zeebe.protocol.record.ExecuteCommandRequestEncoder;
import io.camunda.zeebe.protocol.record.MessageHeaderEncoder;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.test.broker.protocol.MsgPackHelper;
import io.camunda.zeebe.test.broker.protocol.commandapi.ExecuteCommandResponse;
import io.camunda.zeebe.transport.ClientRequest;
import io.camunda.zeebe.transport.ClientTransport;
import io.camunda.zeebe.transport.RequestType;
import io.camunda.zeebe.util.buffer.BufferWriter;
import io.camunda.zeebe.util.sched.future.ActorFuture;
import java.time.Duration;
import java.util.Map;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public final class ExecuteCommandRequest
implements ClientRequest {
    private final MessageHeaderEncoder messageHeaderEncoder = new MessageHeaderEncoder();
    private final ExecuteCommandRequestEncoder requestEncoder = new ExecuteCommandRequestEncoder();
    private final MsgPackHelper msgPackHelper;
    private final ClientTransport output;
    private final String target;
    private int partitionId = ExecuteCommandRequestEncoder.partitionIdNullValue();
    private long key = ExecuteCommandRequestEncoder.keyNullValue();
    private ValueType valueType = ValueType.NULL_VAL;
    private byte[] encodedCmd;
    private ActorFuture<DirectBuffer> responseFuture;
    private Intent intent = null;

    public ExecuteCommandRequest(ClientTransport output, String targetAddress, MsgPackHelper msgPackHelper) {
        this.output = output;
        this.target = targetAddress;
        this.msgPackHelper = msgPackHelper;
    }

    public ExecuteCommandRequest partitionId(int partitionId) {
        this.partitionId = partitionId;
        return this;
    }

    public ExecuteCommandRequest key(long key) {
        this.key = key;
        return this;
    }

    public ExecuteCommandRequest valueType(ValueType valueType) {
        this.valueType = valueType;
        return this;
    }

    public ExecuteCommandRequest intent(Intent intent) {
        this.intent = intent;
        return this;
    }

    public ExecuteCommandRequest command(Map<String, Object> command) {
        this.encodedCmd = this.msgPackHelper.encodeAsMsgPack(command);
        return this;
    }

    public ExecuteCommandRequest command(BufferWriter command) {
        int commandLength = command.getLength();
        this.encodedCmd = new byte[commandLength];
        command.write((MutableDirectBuffer)new UnsafeBuffer(this.encodedCmd), 0);
        return this;
    }

    public ExecuteCommandRequest send() {
        if (this.responseFuture != null) {
            throw new RuntimeException("Cannot send request more than once");
        }
        this.responseFuture = this.output.sendRequestWithRetry(() -> this.target, (ClientRequest)this, Duration.ofSeconds(5L));
        return this;
    }

    public ExecuteCommandResponse await() {
        DirectBuffer responseBuffer = (DirectBuffer)this.responseFuture.join();
        ExecuteCommandResponse result = new ExecuteCommandResponse(this.msgPackHelper);
        result.wrap(responseBuffer, 0, responseBuffer.capacity());
        return result;
    }

    public int getPartitionId() {
        return this.partitionId;
    }

    public RequestType getRequestType() {
        return RequestType.COMMAND;
    }

    public int getLength() {
        return 20 + ExecuteCommandRequestEncoder.valueHeaderLength() + this.encodedCmd.length;
    }

    public void write(MutableDirectBuffer buffer, int offset) {
        this.messageHeaderEncoder.wrap(buffer, offset).schemaId(this.requestEncoder.sbeSchemaId()).templateId(this.requestEncoder.sbeTemplateId()).blockLength(this.requestEncoder.sbeBlockLength()).version(this.requestEncoder.sbeSchemaVersion());
        this.requestEncoder.wrap(buffer, offset + this.messageHeaderEncoder.encodedLength()).partitionId(this.partitionId).key(this.key).valueType(this.valueType).intent(this.intent.value()).putValue(this.encodedCmd, 0, this.encodedCmd.length);
    }
}

