/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.test.broker.protocol.brokerapi;

import io.camunda.zeebe.protocol.record.MessageHeaderDecoder;
import io.camunda.zeebe.test.broker.protocol.MsgPackHelper;
import io.camunda.zeebe.test.broker.protocol.brokerapi.ExecuteCommandRequest;
import io.camunda.zeebe.test.broker.protocol.brokerapi.MessageBuilder;
import io.camunda.zeebe.test.broker.protocol.brokerapi.ResponseStub;
import io.camunda.zeebe.transport.RequestHandler;
import io.camunda.zeebe.transport.ServerOutput;
import io.camunda.zeebe.transport.ServerResponse;
import io.camunda.zeebe.transport.impl.ServerResponseImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public final class StubRequestHandler
implements RequestHandler {
    private final MessageHeaderDecoder headerDecoder = new MessageHeaderDecoder();
    private final List<ResponseStub<ExecuteCommandRequest>> cmdRequestStubs = new ArrayList<ResponseStub<ExecuteCommandRequest>>();
    private final MsgPackHelper msgPackHelper;
    private final List<Object> allRequests = new CopyOnWriteArrayList<Object>();
    private final List<ExecuteCommandRequest> commandRequests = new CopyOnWriteArrayList<ExecuteCommandRequest>();
    private final ServerResponseImpl response = new ServerResponseImpl();

    StubRequestHandler(MsgPackHelper msgPackHelper) {
        this.msgPackHelper = msgPackHelper;
    }

    void addExecuteCommandRequestStub(ResponseStub<ExecuteCommandRequest> stub) {
        this.cmdRequestStubs.add(0, stub);
    }

    List<ExecuteCommandRequest> getReceivedCommandRequests() {
        return this.commandRequests;
    }

    public void onRequest(ServerOutput output, int partitionId, long requestId, DirectBuffer buffer, int offset, int length) {
        UnsafeBuffer copy = new UnsafeBuffer(new byte[length]);
        copy.putBytes(0, buffer, offset, length);
        this.headerDecoder.wrap((DirectBuffer)copy, 0);
        boolean requestHandled = false;
        if (20 == this.headerDecoder.templateId()) {
            ExecuteCommandRequest request = new ExecuteCommandRequest(this.msgPackHelper);
            request.wrap((DirectBuffer)copy, 0, length);
            this.commandRequests.add(request);
            this.allRequests.add(request);
            requestHandled = this.handleRequest(output, partitionId, request, this.cmdRequestStubs, requestId);
        }
        if (!requestHandled) {
            throw new RuntimeException(String.format("no stub applies to request with schema id %s and template id %s ", this.headerDecoder.schemaId(), this.headerDecoder.templateId()));
        }
    }

    private <T> boolean handleRequest(ServerOutput output, int partitionId, T request, List<? extends ResponseStub<T>> responseStubs, long requestId) {
        for (ResponseStub<T> stub : responseStubs) {
            if (!stub.applies(request)) continue;
            if (stub.shouldRespond()) {
                MessageBuilder<T> responseWriter = stub.getResponseWriter();
                responseWriter.initializeFrom(request);
                this.response.reset().setRequestId(requestId).setPartitionId(partitionId).writer(responseWriter);
                responseWriter.beforeResponse();
                output.sendResponse((ServerResponse)this.response);
            }
            return true;
        }
        return false;
    }
}

