/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.test.broker.protocol.commandapi;

import io.atomix.cluster.AtomixCluster;
import io.atomix.cluster.Member;
import io.camunda.zeebe.protocol.impl.encoding.BrokerInfo;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.JobBatchIntent;
import io.camunda.zeebe.protocol.record.intent.JobIntent;
import io.camunda.zeebe.test.broker.protocol.MsgPackHelper;
import io.camunda.zeebe.test.broker.protocol.commandapi.ExecuteCommandRequest;
import io.camunda.zeebe.test.broker.protocol.commandapi.ExecuteCommandRequestBuilder;
import io.camunda.zeebe.test.broker.protocol.commandapi.PartitionTestClient;
import io.camunda.zeebe.test.util.TestUtil;
import io.camunda.zeebe.test.util.record.JobRecordStream;
import io.camunda.zeebe.transport.ClientTransport;
import io.camunda.zeebe.transport.TransportFactory;
import io.camunda.zeebe.util.sched.ActorScheduler;
import io.camunda.zeebe.util.sched.clock.ActorClock;
import io.camunda.zeebe.util.sched.clock.ControlledActorClock;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.agrona.collections.Int2ObjectHashMap;
import org.junit.rules.ExternalResource;

public final class CommandApiRule
extends ExternalResource {
    private static final String DEFAULT_WORKER = "defaultWorker";
    private final int nodeId;
    private final Supplier<AtomixCluster> atomixSupplier;
    private MsgPackHelper msgPackHelper;
    private int defaultPartitionId = -1;
    private final Int2ObjectHashMap<PartitionTestClient> testPartitionClients = new Int2ObjectHashMap();
    private final ControlledActorClock controlledActorClock = new ControlledActorClock();
    private ActorScheduler scheduler;

    public CommandApiRule(Supplier<AtomixCluster> atomixSupplier) {
        this.nodeId = 0;
        this.atomixSupplier = atomixSupplier;
    }

    protected void before() {
        this.scheduler = ActorScheduler.newActorScheduler().setCpuBoundActorThreadCount(1).setActorClock((ActorClock)this.controlledActorClock).build();
        this.scheduler.start();
        this.msgPackHelper = new MsgPackHelper();
        this.waitForTopology();
        List partitionIds = (List)TestUtil.doRepeatedly(this::getPartitionIds).until(p -> !p.isEmpty());
        this.defaultPartitionId = (Integer)partitionIds.get(0);
    }

    protected void after() {
        if (this.scheduler != null) {
            this.scheduler.stop();
        }
    }

    private void waitForTopology() {
        TestUtil.waitUntil(() -> this.getBrokerInfoStream().count() > 0L);
    }

    public ExecuteCommandRequestBuilder createCmdRequest() {
        return this.createCmdRequest(this.defaultPartitionId);
    }

    public ExecuteCommandRequestBuilder createCmdRequest(int partition) {
        ClientTransport outputAdapter = this.createClientTransport();
        Optional<BrokerInfo> broker = this.getBrokerInfoStream().filter(brokerInfo -> brokerInfo.getNodeId() == this.nodeId).findFirst();
        if (broker.isPresent()) {
            BrokerInfo brokerInfo2 = broker.get();
            return new ExecuteCommandRequestBuilder(outputAdapter, brokerInfo2.getCommandApiAddress(), this.msgPackHelper).partitionId(partition);
        }
        throw new IllegalStateException("Node " + this.nodeId + "not yet available");
    }

    private ClientTransport createClientTransport() {
        AtomixCluster atomixCluster = this.fetchAtomix();
        return new TransportFactory(this.scheduler).createClientTransport(atomixCluster.getMessagingService());
    }

    public PartitionTestClient partitionClient() {
        return this.partitionClient(this.defaultPartitionId);
    }

    public PartitionTestClient partitionClient(int partitionId) {
        if (!this.testPartitionClients.containsKey(partitionId)) {
            this.testPartitionClients.put(partitionId, (Object)new PartitionTestClient(this, partitionId));
        }
        return (PartitionTestClient)this.testPartitionClients.get(partitionId);
    }

    public ExecuteCommandRequest activateJobs(int partitionId, String type, long lockDuration, int maxJobsToActivate) {
        ((JobRecordStream)this.partitionClient(partitionId).receiveJobs().withIntent((Intent)JobIntent.CREATED)).withType(type).getFirst();
        return ((ExecuteCommandRequestBuilder)this.createCmdRequest(partitionId).type(ValueType.JOB_BATCH, (Intent)JobBatchIntent.ACTIVATE).command().put("type", (Object)type).put("worker", (Object)DEFAULT_WORKER).put("timeout", (Object)lockDuration).put("maxJobsToActivate", (Object)maxJobsToActivate).put("jobs", Collections.emptyList()).done()).send();
    }

    public ExecuteCommandRequest activateJobs(int partitionId, String type, long lockDuration) {
        return this.activateJobs(partitionId, type, lockDuration, 10);
    }

    public List<Integer> getPartitionIds() {
        return this.getBrokerInfoStream().findFirst().map(brokerInfo -> IntStream.range(1, 1 + brokerInfo.getPartitionsCount()).boxed().collect(Collectors.toList())).orElse(Collections.emptyList());
    }

    private Stream<BrokerInfo> getBrokerInfoStream() {
        AtomixCluster atomixCluster = this.fetchAtomix();
        return atomixCluster.getMembershipService().getMembers().stream().map(Member::properties).map(BrokerInfo::fromProperties).filter(Objects::nonNull);
    }

    private AtomixCluster fetchAtomix() {
        AtomixCluster atomixCluster = this.atomixSupplier.get();
        Objects.requireNonNull(atomixCluster);
        return atomixCluster;
    }
}

