package io.camunda.zeebe.protocol.record.value.deployment;

import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link ProcessMetadataValue} specific assertions - Generated by CustomAssertionGenerator.
 */
@javax.annotation.Generated(value="assertj-assertions-generator")
public abstract class AbstractProcessMetadataValueAssert<S extends AbstractProcessMetadataValueAssert<S, A>, A extends ProcessMetadataValue> extends AbstractObjectAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractProcessMetadataValueAssert}</code> to make assertions on actual ProcessMetadataValue.
   * @param actual the ProcessMetadataValue we want to make assertions on.
   */
  protected AbstractProcessMetadataValueAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual ProcessMetadataValue's bpmnProcessId is equal to the given one.
   * @param bpmnProcessId the given bpmnProcessId to compare the actual ProcessMetadataValue's bpmnProcessId to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ProcessMetadataValue's bpmnProcessId is not equal to the given one.
   */
  public S hasBpmnProcessId(String bpmnProcessId) {
    // check that actual ProcessMetadataValue we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting bpmnProcessId of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // null safe check
    String actualBpmnProcessId = actual.getBpmnProcessId();
    if (!Objects.areEqual(actualBpmnProcessId, bpmnProcessId)) {
      failWithMessage(assertjErrorMessage, actual, bpmnProcessId, actualBpmnProcessId);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ProcessMetadataValue's checksum contains the given byte elements.
   * @param checksum the given elements that should be contained in actual ProcessMetadataValue's checksum.
   * @return this assertion object.
   * @throws AssertionError if the actual ProcessMetadataValue's checksum does not contain all given byte elements.
   */
  public S hasChecksum(byte... checksum) {
    // check that actual ProcessMetadataValue we want to make assertions on is not null.
    isNotNull();

    // check that given byte varargs is not null.
    if (checksum == null) failWithMessage("Expecting checksum parameter not to be null.");

    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Assertions.assertThat(actual.getChecksum()).contains(checksum);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ProcessMetadataValue's checksum contains <b>only</b> the given byte elements and nothing else in whatever order.
   *
   * @param checksum the given elements that should be contained in actual ProcessMetadataValue's checksum.
   * @return this assertion object.
   * @throws AssertionError if the actual ProcessMetadataValue's checksum does not contain all given byte elements and nothing else.
   */
  public S hasOnlyChecksum(byte... checksum) {
    // check that actual ProcessMetadataValue we want to make assertions on is not null.
    isNotNull();

    // check that given byte varargs is not null.
    if (checksum == null) failWithMessage("Expecting checksum parameter not to be null.");

    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Assertions.assertThat(actual.getChecksum()).containsOnly(checksum);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ProcessMetadataValue's checksum does not contain the given byte elements.
   *
   * @param checksum the given elements that should not be in actual ProcessMetadataValue's checksum.
   * @return this assertion object.
   * @throws AssertionError if the actual ProcessMetadataValue's checksum contains any given byte elements.
   */
  public S doesNotHaveChecksum(byte... checksum) {
    // check that actual ProcessMetadataValue we want to make assertions on is not null.
    isNotNull();

    // check that given byte varargs is not null.
    if (checksum == null) failWithMessage("Expecting checksum parameter not to be null.");

    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Assertions.assertThat(actual.getChecksum()).doesNotContain(checksum);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ProcessMetadataValue has no checksum.
   * @return this assertion object.
   * @throws AssertionError if the actual ProcessMetadataValue's checksum is not empty.
   */
  public S hasNoChecksum() {
    // check that actual ProcessMetadataValue we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have checksum but had :\n  <%s>";

    // check that it is not empty
    if (actual.getChecksum().length > 0)  {
      failWithMessage(assertjErrorMessage, actual, java.util.Arrays.toString(actual.getChecksum()));
    }

    // return the current assertion for method chaining
    return myself;
  }


  /**
   * Verifies that the actual ProcessMetadataValue's processDefinitionKey is equal to the given one.
   * @param processDefinitionKey the given processDefinitionKey to compare the actual ProcessMetadataValue's processDefinitionKey to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ProcessMetadataValue's processDefinitionKey is not equal to the given one.
   */
  public S hasProcessDefinitionKey(long processDefinitionKey) {
    // check that actual ProcessMetadataValue we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting processDefinitionKey of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // check
    long actualProcessDefinitionKey = actual.getProcessDefinitionKey();
    if (actualProcessDefinitionKey != processDefinitionKey) {
      failWithMessage(assertjErrorMessage, actual, processDefinitionKey, actualProcessDefinitionKey);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ProcessMetadataValue's resourceName is equal to the given one.
   * @param resourceName the given resourceName to compare the actual ProcessMetadataValue's resourceName to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ProcessMetadataValue's resourceName is not equal to the given one.
   */
  public S hasResourceName(String resourceName) {
    // check that actual ProcessMetadataValue we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting resourceName of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // null safe check
    String actualResourceName = actual.getResourceName();
    if (!Objects.areEqual(actualResourceName, resourceName)) {
      failWithMessage(assertjErrorMessage, actual, resourceName, actualResourceName);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ProcessMetadataValue's version is equal to the given one.
   * @param version the given version to compare the actual ProcessMetadataValue's version to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ProcessMetadataValue's version is not equal to the given one.
   */
  public S hasVersion(int version) {
    // check that actual ProcessMetadataValue we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting version of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // check
    int actualVersion = actual.getVersion();
    if (actualVersion != version) {
      failWithMessage(assertjErrorMessage, actual, version, actualVersion);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
