package io.camunda.zeebe.protocol.record.value.deployment;

import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;

/**
 * Abstract base class for {@link Process} specific assertions - Generated by CustomAssertionGenerator.
 */
@javax.annotation.Generated(value="assertj-assertions-generator")
public abstract class AbstractProcessAssert<S extends AbstractProcessAssert<S, A>, A extends Process> extends AbstractObjectAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractProcessAssert}</code> to make assertions on actual Process.
   * @param actual the Process we want to make assertions on.
   */
  protected AbstractProcessAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual Process's resource contains the given byte elements.
   * @param resource the given elements that should be contained in actual Process's resource.
   * @return this assertion object.
   * @throws AssertionError if the actual Process's resource does not contain all given byte elements.
   */
  public S hasResource(byte... resource) {
    // check that actual Process we want to make assertions on is not null.
    isNotNull();

    // check that given byte varargs is not null.
    if (resource == null) failWithMessage("Expecting resource parameter not to be null.");

    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Assertions.assertThat(actual.getResource()).contains(resource);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Process's resource contains <b>only</b> the given byte elements and nothing else in whatever order.
   *
   * @param resource the given elements that should be contained in actual Process's resource.
   * @return this assertion object.
   * @throws AssertionError if the actual Process's resource does not contain all given byte elements and nothing else.
   */
  public S hasOnlyResource(byte... resource) {
    // check that actual Process we want to make assertions on is not null.
    isNotNull();

    // check that given byte varargs is not null.
    if (resource == null) failWithMessage("Expecting resource parameter not to be null.");

    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Assertions.assertThat(actual.getResource()).containsOnly(resource);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Process's resource does not contain the given byte elements.
   *
   * @param resource the given elements that should not be in actual Process's resource.
   * @return this assertion object.
   * @throws AssertionError if the actual Process's resource contains any given byte elements.
   */
  public S doesNotHaveResource(byte... resource) {
    // check that actual Process we want to make assertions on is not null.
    isNotNull();

    // check that given byte varargs is not null.
    if (resource == null) failWithMessage("Expecting resource parameter not to be null.");

    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Assertions.assertThat(actual.getResource()).doesNotContain(resource);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Process has no resource.
   * @return this assertion object.
   * @throws AssertionError if the actual Process's resource is not empty.
   */
  public S hasNoResource() {
    // check that actual Process we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have resource but had :\n  <%s>";

    // check that it is not empty
    if (actual.getResource().length > 0)  {
      failWithMessage(assertjErrorMessage, actual, java.util.Arrays.toString(actual.getResource()));
    }

    // return the current assertion for method chaining
    return myself;
  }


}
