package io.camunda.zeebe.protocol.record.value;

import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link VariableRecordValue} specific assertions - Generated by CustomAssertionGenerator.
 */
@javax.annotation.Generated(value="assertj-assertions-generator")
public abstract class AbstractVariableRecordValueAssert<S extends AbstractVariableRecordValueAssert<S, A>, A extends VariableRecordValue> extends AbstractObjectAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractVariableRecordValueAssert}</code> to make assertions on actual VariableRecordValue.
   * @param actual the VariableRecordValue we want to make assertions on.
   */
  protected AbstractVariableRecordValueAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual VariableRecordValue's name is equal to the given one.
   * @param name the given name to compare the actual VariableRecordValue's name to.
   * @return this assertion object.
   * @throws AssertionError - if the actual VariableRecordValue's name is not equal to the given one.
   */
  public S hasName(String name) {
    // check that actual VariableRecordValue we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting name of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // null safe check
    String actualName = actual.getName();
    if (!Objects.areEqual(actualName, name)) {
      failWithMessage(assertjErrorMessage, actual, name, actualName);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual VariableRecordValue's processDefinitionKey is equal to the given one.
   * @param processDefinitionKey the given processDefinitionKey to compare the actual VariableRecordValue's processDefinitionKey to.
   * @return this assertion object.
   * @throws AssertionError - if the actual VariableRecordValue's processDefinitionKey is not equal to the given one.
   */
  public S hasProcessDefinitionKey(long processDefinitionKey) {
    // check that actual VariableRecordValue we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting processDefinitionKey of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // check
    long actualProcessDefinitionKey = actual.getProcessDefinitionKey();
    if (actualProcessDefinitionKey != processDefinitionKey) {
      failWithMessage(assertjErrorMessage, actual, processDefinitionKey, actualProcessDefinitionKey);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual VariableRecordValue's processInstanceKey is equal to the given one.
   * @param processInstanceKey the given processInstanceKey to compare the actual VariableRecordValue's processInstanceKey to.
   * @return this assertion object.
   * @throws AssertionError - if the actual VariableRecordValue's processInstanceKey is not equal to the given one.
   */
  public S hasProcessInstanceKey(long processInstanceKey) {
    // check that actual VariableRecordValue we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting processInstanceKey of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // check
    long actualProcessInstanceKey = actual.getProcessInstanceKey();
    if (actualProcessInstanceKey != processInstanceKey) {
      failWithMessage(assertjErrorMessage, actual, processInstanceKey, actualProcessInstanceKey);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual VariableRecordValue's scopeKey is equal to the given one.
   * @param scopeKey the given scopeKey to compare the actual VariableRecordValue's scopeKey to.
   * @return this assertion object.
   * @throws AssertionError - if the actual VariableRecordValue's scopeKey is not equal to the given one.
   */
  public S hasScopeKey(long scopeKey) {
    // check that actual VariableRecordValue we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting scopeKey of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // check
    long actualScopeKey = actual.getScopeKey();
    if (actualScopeKey != scopeKey) {
      failWithMessage(assertjErrorMessage, actual, scopeKey, actualScopeKey);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual VariableRecordValue's value is equal to the given one.
   * @param value the given value to compare the actual VariableRecordValue's value to.
   * @return this assertion object.
   * @throws AssertionError - if the actual VariableRecordValue's value is not equal to the given one.
   */
  public S hasValue(String value) {
    // check that actual VariableRecordValue we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting value of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // null safe check
    String actualValue = actual.getValue();
    if (!Objects.areEqual(actualValue, value)) {
      failWithMessage(assertjErrorMessage, actual, value, actualValue);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
