package io.camunda.zeebe.protocol.record.value;

import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link TimerRecordValue} specific assertions - Generated by CustomAssertionGenerator.
 */
@javax.annotation.Generated(value="assertj-assertions-generator")
public abstract class AbstractTimerRecordValueAssert<S extends AbstractTimerRecordValueAssert<S, A>, A extends TimerRecordValue> extends AbstractObjectAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractTimerRecordValueAssert}</code> to make assertions on actual TimerRecordValue.
   * @param actual the TimerRecordValue we want to make assertions on.
   */
  protected AbstractTimerRecordValueAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual TimerRecordValue's dueDate is equal to the given one.
   * @param dueDate the given dueDate to compare the actual TimerRecordValue's dueDate to.
   * @return this assertion object.
   * @throws AssertionError - if the actual TimerRecordValue's dueDate is not equal to the given one.
   */
  public S hasDueDate(long dueDate) {
    // check that actual TimerRecordValue we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting dueDate of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // check
    long actualDueDate = actual.getDueDate();
    if (actualDueDate != dueDate) {
      failWithMessage(assertjErrorMessage, actual, dueDate, actualDueDate);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual TimerRecordValue's elementInstanceKey is equal to the given one.
   * @param elementInstanceKey the given elementInstanceKey to compare the actual TimerRecordValue's elementInstanceKey to.
   * @return this assertion object.
   * @throws AssertionError - if the actual TimerRecordValue's elementInstanceKey is not equal to the given one.
   */
  public S hasElementInstanceKey(long elementInstanceKey) {
    // check that actual TimerRecordValue we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting elementInstanceKey of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // check
    long actualElementInstanceKey = actual.getElementInstanceKey();
    if (actualElementInstanceKey != elementInstanceKey) {
      failWithMessage(assertjErrorMessage, actual, elementInstanceKey, actualElementInstanceKey);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual TimerRecordValue's processDefinitionKey is equal to the given one.
   * @param processDefinitionKey the given processDefinitionKey to compare the actual TimerRecordValue's processDefinitionKey to.
   * @return this assertion object.
   * @throws AssertionError - if the actual TimerRecordValue's processDefinitionKey is not equal to the given one.
   */
  public S hasProcessDefinitionKey(long processDefinitionKey) {
    // check that actual TimerRecordValue we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting processDefinitionKey of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // check
    long actualProcessDefinitionKey = actual.getProcessDefinitionKey();
    if (actualProcessDefinitionKey != processDefinitionKey) {
      failWithMessage(assertjErrorMessage, actual, processDefinitionKey, actualProcessDefinitionKey);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual TimerRecordValue's processInstanceKey is equal to the given one.
   * @param processInstanceKey the given processInstanceKey to compare the actual TimerRecordValue's processInstanceKey to.
   * @return this assertion object.
   * @throws AssertionError - if the actual TimerRecordValue's processInstanceKey is not equal to the given one.
   */
  public S hasProcessInstanceKey(long processInstanceKey) {
    // check that actual TimerRecordValue we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting processInstanceKey of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // check
    long actualProcessInstanceKey = actual.getProcessInstanceKey();
    if (actualProcessInstanceKey != processInstanceKey) {
      failWithMessage(assertjErrorMessage, actual, processInstanceKey, actualProcessInstanceKey);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual TimerRecordValue's repetitions is equal to the given one.
   * @param repetitions the given repetitions to compare the actual TimerRecordValue's repetitions to.
   * @return this assertion object.
   * @throws AssertionError - if the actual TimerRecordValue's repetitions is not equal to the given one.
   */
  public S hasRepetitions(int repetitions) {
    // check that actual TimerRecordValue we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting repetitions of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // check
    int actualRepetitions = actual.getRepetitions();
    if (actualRepetitions != repetitions) {
      failWithMessage(assertjErrorMessage, actual, repetitions, actualRepetitions);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual TimerRecordValue's targetElementId is equal to the given one.
   * @param targetElementId the given targetElementId to compare the actual TimerRecordValue's targetElementId to.
   * @return this assertion object.
   * @throws AssertionError - if the actual TimerRecordValue's targetElementId is not equal to the given one.
   */
  public S hasTargetElementId(String targetElementId) {
    // check that actual TimerRecordValue we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting targetElementId of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // null safe check
    String actualTargetElementId = actual.getTargetElementId();
    if (!Objects.areEqual(actualTargetElementId, targetElementId)) {
      failWithMessage(assertjErrorMessage, actual, targetElementId, actualTargetElementId);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
