package io.camunda.zeebe.protocol.record.value;

import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link ProcessMessageSubscriptionRecordValue} specific assertions - Generated by CustomAssertionGenerator.
 */
@javax.annotation.Generated(value="assertj-assertions-generator")
public abstract class AbstractProcessMessageSubscriptionRecordValueAssert<S extends AbstractProcessMessageSubscriptionRecordValueAssert<S, A>, A extends ProcessMessageSubscriptionRecordValue> extends AbstractObjectAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractProcessMessageSubscriptionRecordValueAssert}</code> to make assertions on actual ProcessMessageSubscriptionRecordValue.
   * @param actual the ProcessMessageSubscriptionRecordValue we want to make assertions on.
   */
  protected AbstractProcessMessageSubscriptionRecordValueAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual ProcessMessageSubscriptionRecordValue's bpmnProcessId is equal to the given one.
   * @param bpmnProcessId the given bpmnProcessId to compare the actual ProcessMessageSubscriptionRecordValue's bpmnProcessId to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ProcessMessageSubscriptionRecordValue's bpmnProcessId is not equal to the given one.
   */
  public S hasBpmnProcessId(String bpmnProcessId) {
    // check that actual ProcessMessageSubscriptionRecordValue we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting bpmnProcessId of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // null safe check
    String actualBpmnProcessId = actual.getBpmnProcessId();
    if (!Objects.areEqual(actualBpmnProcessId, bpmnProcessId)) {
      failWithMessage(assertjErrorMessage, actual, bpmnProcessId, actualBpmnProcessId);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ProcessMessageSubscriptionRecordValue's correlationKey is equal to the given one.
   * @param correlationKey the given correlationKey to compare the actual ProcessMessageSubscriptionRecordValue's correlationKey to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ProcessMessageSubscriptionRecordValue's correlationKey is not equal to the given one.
   */
  public S hasCorrelationKey(String correlationKey) {
    // check that actual ProcessMessageSubscriptionRecordValue we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting correlationKey of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // null safe check
    String actualCorrelationKey = actual.getCorrelationKey();
    if (!Objects.areEqual(actualCorrelationKey, correlationKey)) {
      failWithMessage(assertjErrorMessage, actual, correlationKey, actualCorrelationKey);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ProcessMessageSubscriptionRecordValue's elementId is equal to the given one.
   * @param elementId the given elementId to compare the actual ProcessMessageSubscriptionRecordValue's elementId to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ProcessMessageSubscriptionRecordValue's elementId is not equal to the given one.
   */
  public S hasElementId(String elementId) {
    // check that actual ProcessMessageSubscriptionRecordValue we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting elementId of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // null safe check
    String actualElementId = actual.getElementId();
    if (!Objects.areEqual(actualElementId, elementId)) {
      failWithMessage(assertjErrorMessage, actual, elementId, actualElementId);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ProcessMessageSubscriptionRecordValue's elementInstanceKey is equal to the given one.
   * @param elementInstanceKey the given elementInstanceKey to compare the actual ProcessMessageSubscriptionRecordValue's elementInstanceKey to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ProcessMessageSubscriptionRecordValue's elementInstanceKey is not equal to the given one.
   */
  public S hasElementInstanceKey(long elementInstanceKey) {
    // check that actual ProcessMessageSubscriptionRecordValue we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting elementInstanceKey of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // check
    long actualElementInstanceKey = actual.getElementInstanceKey();
    if (actualElementInstanceKey != elementInstanceKey) {
      failWithMessage(assertjErrorMessage, actual, elementInstanceKey, actualElementInstanceKey);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ProcessMessageSubscriptionRecordValue is interrupting.
   * @return this assertion object.
   * @throws AssertionError - if the actual ProcessMessageSubscriptionRecordValue is not interrupting.
   */
  public S isInterrupting() {
    // check that actual ProcessMessageSubscriptionRecordValue we want to make assertions on is not null.
    isNotNull();

    // check that property call/field access is true
    if (!actual.isInterrupting()) {
      failWithMessage("\nExpecting that actual ProcessMessageSubscriptionRecordValue is interrupting but is not.");
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ProcessMessageSubscriptionRecordValue is not interrupting.
   * @return this assertion object.
   * @throws AssertionError - if the actual ProcessMessageSubscriptionRecordValue is interrupting.
   */
  public S isNotInterrupting() {
    // check that actual ProcessMessageSubscriptionRecordValue we want to make assertions on is not null.
    isNotNull();

    // check that property call/field access is false
    if (actual.isInterrupting()) {
      failWithMessage("\nExpecting that actual ProcessMessageSubscriptionRecordValue is not interrupting but is.");
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ProcessMessageSubscriptionRecordValue's messageKey is equal to the given one.
   * @param messageKey the given messageKey to compare the actual ProcessMessageSubscriptionRecordValue's messageKey to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ProcessMessageSubscriptionRecordValue's messageKey is not equal to the given one.
   */
  public S hasMessageKey(long messageKey) {
    // check that actual ProcessMessageSubscriptionRecordValue we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting messageKey of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // check
    long actualMessageKey = actual.getMessageKey();
    if (actualMessageKey != messageKey) {
      failWithMessage(assertjErrorMessage, actual, messageKey, actualMessageKey);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ProcessMessageSubscriptionRecordValue's messageName is equal to the given one.
   * @param messageName the given messageName to compare the actual ProcessMessageSubscriptionRecordValue's messageName to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ProcessMessageSubscriptionRecordValue's messageName is not equal to the given one.
   */
  public S hasMessageName(String messageName) {
    // check that actual ProcessMessageSubscriptionRecordValue we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting messageName of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // null safe check
    String actualMessageName = actual.getMessageName();
    if (!Objects.areEqual(actualMessageName, messageName)) {
      failWithMessage(assertjErrorMessage, actual, messageName, actualMessageName);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ProcessMessageSubscriptionRecordValue's processInstanceKey is equal to the given one.
   * @param processInstanceKey the given processInstanceKey to compare the actual ProcessMessageSubscriptionRecordValue's processInstanceKey to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ProcessMessageSubscriptionRecordValue's processInstanceKey is not equal to the given one.
   */
  public S hasProcessInstanceKey(long processInstanceKey) {
    // check that actual ProcessMessageSubscriptionRecordValue we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting processInstanceKey of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // check
    long actualProcessInstanceKey = actual.getProcessInstanceKey();
    if (actualProcessInstanceKey != processInstanceKey) {
      failWithMessage(assertjErrorMessage, actual, processInstanceKey, actualProcessInstanceKey);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
