package io.camunda.zeebe.protocol.record.value;

import org.assertj.core.api.AbstractObjectAssert;

/**
 * Abstract base class for {@link ProcessInstanceRelated} specific assertions - Generated by CustomAssertionGenerator.
 */
@javax.annotation.Generated(value="assertj-assertions-generator")
public abstract class AbstractProcessInstanceRelatedAssert<S extends AbstractProcessInstanceRelatedAssert<S, A>, A extends ProcessInstanceRelated> extends AbstractObjectAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractProcessInstanceRelatedAssert}</code> to make assertions on actual ProcessInstanceRelated.
   * @param actual the ProcessInstanceRelated we want to make assertions on.
   */
  protected AbstractProcessInstanceRelatedAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual ProcessInstanceRelated's processInstanceKey is equal to the given one.
   * @param processInstanceKey the given processInstanceKey to compare the actual ProcessInstanceRelated's processInstanceKey to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ProcessInstanceRelated's processInstanceKey is not equal to the given one.
   */
  public S hasProcessInstanceKey(long processInstanceKey) {
    // check that actual ProcessInstanceRelated we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting processInstanceKey of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // check
    long actualProcessInstanceKey = actual.getProcessInstanceKey();
    if (actualProcessInstanceKey != processInstanceKey) {
      failWithMessage(assertjErrorMessage, actual, processInstanceKey, actualProcessInstanceKey);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
