package io.camunda.zeebe.protocol.record.value;

import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link ProcessInstanceRecordValue} specific assertions - Generated by CustomAssertionGenerator.
 */
@javax.annotation.Generated(value="assertj-assertions-generator")
public abstract class AbstractProcessInstanceRecordValueAssert<S extends AbstractProcessInstanceRecordValueAssert<S, A>, A extends ProcessInstanceRecordValue> extends AbstractObjectAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractProcessInstanceRecordValueAssert}</code> to make assertions on actual ProcessInstanceRecordValue.
   * @param actual the ProcessInstanceRecordValue we want to make assertions on.
   */
  protected AbstractProcessInstanceRecordValueAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual ProcessInstanceRecordValue's bpmnElementType is equal to the given one.
   * @param bpmnElementType the given bpmnElementType to compare the actual ProcessInstanceRecordValue's bpmnElementType to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ProcessInstanceRecordValue's bpmnElementType is not equal to the given one.
   */
  public S hasBpmnElementType(BpmnElementType bpmnElementType) {
    // check that actual ProcessInstanceRecordValue we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting bpmnElementType of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // null safe check
    BpmnElementType actualBpmnElementType = actual.getBpmnElementType();
    if (!Objects.areEqual(actualBpmnElementType, bpmnElementType)) {
      failWithMessage(assertjErrorMessage, actual, bpmnElementType, actualBpmnElementType);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ProcessInstanceRecordValue's bpmnProcessId is equal to the given one.
   * @param bpmnProcessId the given bpmnProcessId to compare the actual ProcessInstanceRecordValue's bpmnProcessId to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ProcessInstanceRecordValue's bpmnProcessId is not equal to the given one.
   */
  public S hasBpmnProcessId(String bpmnProcessId) {
    // check that actual ProcessInstanceRecordValue we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting bpmnProcessId of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // null safe check
    String actualBpmnProcessId = actual.getBpmnProcessId();
    if (!Objects.areEqual(actualBpmnProcessId, bpmnProcessId)) {
      failWithMessage(assertjErrorMessage, actual, bpmnProcessId, actualBpmnProcessId);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ProcessInstanceRecordValue's elementId is equal to the given one.
   * @param elementId the given elementId to compare the actual ProcessInstanceRecordValue's elementId to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ProcessInstanceRecordValue's elementId is not equal to the given one.
   */
  public S hasElementId(String elementId) {
    // check that actual ProcessInstanceRecordValue we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting elementId of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // null safe check
    String actualElementId = actual.getElementId();
    if (!Objects.areEqual(actualElementId, elementId)) {
      failWithMessage(assertjErrorMessage, actual, elementId, actualElementId);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ProcessInstanceRecordValue's flowScopeKey is equal to the given one.
   * @param flowScopeKey the given flowScopeKey to compare the actual ProcessInstanceRecordValue's flowScopeKey to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ProcessInstanceRecordValue's flowScopeKey is not equal to the given one.
   */
  public S hasFlowScopeKey(long flowScopeKey) {
    // check that actual ProcessInstanceRecordValue we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting flowScopeKey of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // check
    long actualFlowScopeKey = actual.getFlowScopeKey();
    if (actualFlowScopeKey != flowScopeKey) {
      failWithMessage(assertjErrorMessage, actual, flowScopeKey, actualFlowScopeKey);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ProcessInstanceRecordValue's parentElementInstanceKey is equal to the given one.
   * @param parentElementInstanceKey the given parentElementInstanceKey to compare the actual ProcessInstanceRecordValue's parentElementInstanceKey to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ProcessInstanceRecordValue's parentElementInstanceKey is not equal to the given one.
   */
  public S hasParentElementInstanceKey(long parentElementInstanceKey) {
    // check that actual ProcessInstanceRecordValue we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting parentElementInstanceKey of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // check
    long actualParentElementInstanceKey = actual.getParentElementInstanceKey();
    if (actualParentElementInstanceKey != parentElementInstanceKey) {
      failWithMessage(assertjErrorMessage, actual, parentElementInstanceKey, actualParentElementInstanceKey);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ProcessInstanceRecordValue's parentProcessInstanceKey is equal to the given one.
   * @param parentProcessInstanceKey the given parentProcessInstanceKey to compare the actual ProcessInstanceRecordValue's parentProcessInstanceKey to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ProcessInstanceRecordValue's parentProcessInstanceKey is not equal to the given one.
   */
  public S hasParentProcessInstanceKey(long parentProcessInstanceKey) {
    // check that actual ProcessInstanceRecordValue we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting parentProcessInstanceKey of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // check
    long actualParentProcessInstanceKey = actual.getParentProcessInstanceKey();
    if (actualParentProcessInstanceKey != parentProcessInstanceKey) {
      failWithMessage(assertjErrorMessage, actual, parentProcessInstanceKey, actualParentProcessInstanceKey);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ProcessInstanceRecordValue's processDefinitionKey is equal to the given one.
   * @param processDefinitionKey the given processDefinitionKey to compare the actual ProcessInstanceRecordValue's processDefinitionKey to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ProcessInstanceRecordValue's processDefinitionKey is not equal to the given one.
   */
  public S hasProcessDefinitionKey(long processDefinitionKey) {
    // check that actual ProcessInstanceRecordValue we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting processDefinitionKey of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // check
    long actualProcessDefinitionKey = actual.getProcessDefinitionKey();
    if (actualProcessDefinitionKey != processDefinitionKey) {
      failWithMessage(assertjErrorMessage, actual, processDefinitionKey, actualProcessDefinitionKey);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ProcessInstanceRecordValue's processInstanceKey is equal to the given one.
   * @param processInstanceKey the given processInstanceKey to compare the actual ProcessInstanceRecordValue's processInstanceKey to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ProcessInstanceRecordValue's processInstanceKey is not equal to the given one.
   */
  public S hasProcessInstanceKey(long processInstanceKey) {
    // check that actual ProcessInstanceRecordValue we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting processInstanceKey of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // check
    long actualProcessInstanceKey = actual.getProcessInstanceKey();
    if (actualProcessInstanceKey != processInstanceKey) {
      failWithMessage(assertjErrorMessage, actual, processInstanceKey, actualProcessInstanceKey);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ProcessInstanceRecordValue's version is equal to the given one.
   * @param version the given version to compare the actual ProcessInstanceRecordValue's version to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ProcessInstanceRecordValue's version is not equal to the given one.
   */
  public S hasVersion(int version) {
    // check that actual ProcessInstanceRecordValue we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting version of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // check
    int actualVersion = actual.getVersion();
    if (actualVersion != version) {
      failWithMessage(assertjErrorMessage, actual, version, actualVersion);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
