package io.camunda.zeebe.protocol.record.value;

import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link ProcessInstanceCreationRecordValue} specific assertions - Generated by CustomAssertionGenerator.
 */
@javax.annotation.Generated(value="assertj-assertions-generator")
public abstract class AbstractProcessInstanceCreationRecordValueAssert<S extends AbstractProcessInstanceCreationRecordValueAssert<S, A>, A extends ProcessInstanceCreationRecordValue> extends AbstractObjectAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractProcessInstanceCreationRecordValueAssert}</code> to make assertions on actual ProcessInstanceCreationRecordValue.
   * @param actual the ProcessInstanceCreationRecordValue we want to make assertions on.
   */
  protected AbstractProcessInstanceCreationRecordValueAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual ProcessInstanceCreationRecordValue's bpmnProcessId is equal to the given one.
   * @param bpmnProcessId the given bpmnProcessId to compare the actual ProcessInstanceCreationRecordValue's bpmnProcessId to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ProcessInstanceCreationRecordValue's bpmnProcessId is not equal to the given one.
   */
  public S hasBpmnProcessId(String bpmnProcessId) {
    // check that actual ProcessInstanceCreationRecordValue we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting bpmnProcessId of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // null safe check
    String actualBpmnProcessId = actual.getBpmnProcessId();
    if (!Objects.areEqual(actualBpmnProcessId, bpmnProcessId)) {
      failWithMessage(assertjErrorMessage, actual, bpmnProcessId, actualBpmnProcessId);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ProcessInstanceCreationRecordValue's processDefinitionKey is equal to the given one.
   * @param processDefinitionKey the given processDefinitionKey to compare the actual ProcessInstanceCreationRecordValue's processDefinitionKey to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ProcessInstanceCreationRecordValue's processDefinitionKey is not equal to the given one.
   */
  public S hasProcessDefinitionKey(long processDefinitionKey) {
    // check that actual ProcessInstanceCreationRecordValue we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting processDefinitionKey of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // check
    long actualProcessDefinitionKey = actual.getProcessDefinitionKey();
    if (actualProcessDefinitionKey != processDefinitionKey) {
      failWithMessage(assertjErrorMessage, actual, processDefinitionKey, actualProcessDefinitionKey);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ProcessInstanceCreationRecordValue's version is equal to the given one.
   * @param version the given version to compare the actual ProcessInstanceCreationRecordValue's version to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ProcessInstanceCreationRecordValue's version is not equal to the given one.
   */
  public S hasVersion(int version) {
    // check that actual ProcessInstanceCreationRecordValue we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting version of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // check
    int actualVersion = actual.getVersion();
    if (actualVersion != version) {
      failWithMessage(assertjErrorMessage, actual, version, actualVersion);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
