package io.camunda.zeebe.protocol.record.value;

import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link ProcessEventRecordValue} specific assertions - Generated by CustomAssertionGenerator.
 */
@javax.annotation.Generated(value="assertj-assertions-generator")
public abstract class AbstractProcessEventRecordValueAssert<S extends AbstractProcessEventRecordValueAssert<S, A>, A extends ProcessEventRecordValue> extends AbstractObjectAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractProcessEventRecordValueAssert}</code> to make assertions on actual ProcessEventRecordValue.
   * @param actual the ProcessEventRecordValue we want to make assertions on.
   */
  protected AbstractProcessEventRecordValueAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual ProcessEventRecordValue's processDefinitionKey is equal to the given one.
   * @param processDefinitionKey the given processDefinitionKey to compare the actual ProcessEventRecordValue's processDefinitionKey to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ProcessEventRecordValue's processDefinitionKey is not equal to the given one.
   */
  public S hasProcessDefinitionKey(long processDefinitionKey) {
    // check that actual ProcessEventRecordValue we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting processDefinitionKey of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // check
    long actualProcessDefinitionKey = actual.getProcessDefinitionKey();
    if (actualProcessDefinitionKey != processDefinitionKey) {
      failWithMessage(assertjErrorMessage, actual, processDefinitionKey, actualProcessDefinitionKey);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ProcessEventRecordValue's scopeKey is equal to the given one.
   * @param scopeKey the given scopeKey to compare the actual ProcessEventRecordValue's scopeKey to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ProcessEventRecordValue's scopeKey is not equal to the given one.
   */
  public S hasScopeKey(long scopeKey) {
    // check that actual ProcessEventRecordValue we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting scopeKey of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // check
    long actualScopeKey = actual.getScopeKey();
    if (actualScopeKey != scopeKey) {
      failWithMessage(assertjErrorMessage, actual, scopeKey, actualScopeKey);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ProcessEventRecordValue's targetElementId is equal to the given one.
   * @param targetElementId the given targetElementId to compare the actual ProcessEventRecordValue's targetElementId to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ProcessEventRecordValue's targetElementId is not equal to the given one.
   */
  public S hasTargetElementId(String targetElementId) {
    // check that actual ProcessEventRecordValue we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting targetElementId of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // null safe check
    String actualTargetElementId = actual.getTargetElementId();
    if (!Objects.areEqual(actualTargetElementId, targetElementId)) {
      failWithMessage(assertjErrorMessage, actual, targetElementId, actualTargetElementId);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
