package io.camunda.zeebe.protocol.record.value;

import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link MessageSubscriptionRecordValue} specific assertions - Generated by CustomAssertionGenerator.
 */
@javax.annotation.Generated(value="assertj-assertions-generator")
public abstract class AbstractMessageSubscriptionRecordValueAssert<S extends AbstractMessageSubscriptionRecordValueAssert<S, A>, A extends MessageSubscriptionRecordValue> extends AbstractObjectAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractMessageSubscriptionRecordValueAssert}</code> to make assertions on actual MessageSubscriptionRecordValue.
   * @param actual the MessageSubscriptionRecordValue we want to make assertions on.
   */
  protected AbstractMessageSubscriptionRecordValueAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual MessageSubscriptionRecordValue's bpmnProcessId is equal to the given one.
   * @param bpmnProcessId the given bpmnProcessId to compare the actual MessageSubscriptionRecordValue's bpmnProcessId to.
   * @return this assertion object.
   * @throws AssertionError - if the actual MessageSubscriptionRecordValue's bpmnProcessId is not equal to the given one.
   */
  public S hasBpmnProcessId(String bpmnProcessId) {
    // check that actual MessageSubscriptionRecordValue we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting bpmnProcessId of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // null safe check
    String actualBpmnProcessId = actual.getBpmnProcessId();
    if (!Objects.areEqual(actualBpmnProcessId, bpmnProcessId)) {
      failWithMessage(assertjErrorMessage, actual, bpmnProcessId, actualBpmnProcessId);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual MessageSubscriptionRecordValue's correlationKey is equal to the given one.
   * @param correlationKey the given correlationKey to compare the actual MessageSubscriptionRecordValue's correlationKey to.
   * @return this assertion object.
   * @throws AssertionError - if the actual MessageSubscriptionRecordValue's correlationKey is not equal to the given one.
   */
  public S hasCorrelationKey(String correlationKey) {
    // check that actual MessageSubscriptionRecordValue we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting correlationKey of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // null safe check
    String actualCorrelationKey = actual.getCorrelationKey();
    if (!Objects.areEqual(actualCorrelationKey, correlationKey)) {
      failWithMessage(assertjErrorMessage, actual, correlationKey, actualCorrelationKey);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual MessageSubscriptionRecordValue's elementInstanceKey is equal to the given one.
   * @param elementInstanceKey the given elementInstanceKey to compare the actual MessageSubscriptionRecordValue's elementInstanceKey to.
   * @return this assertion object.
   * @throws AssertionError - if the actual MessageSubscriptionRecordValue's elementInstanceKey is not equal to the given one.
   */
  public S hasElementInstanceKey(long elementInstanceKey) {
    // check that actual MessageSubscriptionRecordValue we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting elementInstanceKey of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // check
    long actualElementInstanceKey = actual.getElementInstanceKey();
    if (actualElementInstanceKey != elementInstanceKey) {
      failWithMessage(assertjErrorMessage, actual, elementInstanceKey, actualElementInstanceKey);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual MessageSubscriptionRecordValue is interrupting.
   * @return this assertion object.
   * @throws AssertionError - if the actual MessageSubscriptionRecordValue is not interrupting.
   */
  public S isInterrupting() {
    // check that actual MessageSubscriptionRecordValue we want to make assertions on is not null.
    isNotNull();

    // check that property call/field access is true
    if (!actual.isInterrupting()) {
      failWithMessage("\nExpecting that actual MessageSubscriptionRecordValue is interrupting but is not.");
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual MessageSubscriptionRecordValue is not interrupting.
   * @return this assertion object.
   * @throws AssertionError - if the actual MessageSubscriptionRecordValue is interrupting.
   */
  public S isNotInterrupting() {
    // check that actual MessageSubscriptionRecordValue we want to make assertions on is not null.
    isNotNull();

    // check that property call/field access is false
    if (actual.isInterrupting()) {
      failWithMessage("\nExpecting that actual MessageSubscriptionRecordValue is not interrupting but is.");
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual MessageSubscriptionRecordValue's messageKey is equal to the given one.
   * @param messageKey the given messageKey to compare the actual MessageSubscriptionRecordValue's messageKey to.
   * @return this assertion object.
   * @throws AssertionError - if the actual MessageSubscriptionRecordValue's messageKey is not equal to the given one.
   */
  public S hasMessageKey(long messageKey) {
    // check that actual MessageSubscriptionRecordValue we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting messageKey of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // check
    long actualMessageKey = actual.getMessageKey();
    if (actualMessageKey != messageKey) {
      failWithMessage(assertjErrorMessage, actual, messageKey, actualMessageKey);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual MessageSubscriptionRecordValue's messageName is equal to the given one.
   * @param messageName the given messageName to compare the actual MessageSubscriptionRecordValue's messageName to.
   * @return this assertion object.
   * @throws AssertionError - if the actual MessageSubscriptionRecordValue's messageName is not equal to the given one.
   */
  public S hasMessageName(String messageName) {
    // check that actual MessageSubscriptionRecordValue we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting messageName of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // null safe check
    String actualMessageName = actual.getMessageName();
    if (!Objects.areEqual(actualMessageName, messageName)) {
      failWithMessage(assertjErrorMessage, actual, messageName, actualMessageName);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual MessageSubscriptionRecordValue's processInstanceKey is equal to the given one.
   * @param processInstanceKey the given processInstanceKey to compare the actual MessageSubscriptionRecordValue's processInstanceKey to.
   * @return this assertion object.
   * @throws AssertionError - if the actual MessageSubscriptionRecordValue's processInstanceKey is not equal to the given one.
   */
  public S hasProcessInstanceKey(long processInstanceKey) {
    // check that actual MessageSubscriptionRecordValue we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting processInstanceKey of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // check
    long actualProcessInstanceKey = actual.getProcessInstanceKey();
    if (actualProcessInstanceKey != processInstanceKey) {
      failWithMessage(assertjErrorMessage, actual, processInstanceKey, actualProcessInstanceKey);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
