package io.camunda.zeebe.protocol.record.value;

import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link MessageStartEventSubscriptionRecordValue} specific assertions - Generated by CustomAssertionGenerator.
 */
@javax.annotation.Generated(value="assertj-assertions-generator")
public abstract class AbstractMessageStartEventSubscriptionRecordValueAssert<S extends AbstractMessageStartEventSubscriptionRecordValueAssert<S, A>, A extends MessageStartEventSubscriptionRecordValue> extends AbstractObjectAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractMessageStartEventSubscriptionRecordValueAssert}</code> to make assertions on actual MessageStartEventSubscriptionRecordValue.
   * @param actual the MessageStartEventSubscriptionRecordValue we want to make assertions on.
   */
  protected AbstractMessageStartEventSubscriptionRecordValueAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual MessageStartEventSubscriptionRecordValue's bpmnProcessId is equal to the given one.
   * @param bpmnProcessId the given bpmnProcessId to compare the actual MessageStartEventSubscriptionRecordValue's bpmnProcessId to.
   * @return this assertion object.
   * @throws AssertionError - if the actual MessageStartEventSubscriptionRecordValue's bpmnProcessId is not equal to the given one.
   */
  public S hasBpmnProcessId(String bpmnProcessId) {
    // check that actual MessageStartEventSubscriptionRecordValue we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting bpmnProcessId of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // null safe check
    String actualBpmnProcessId = actual.getBpmnProcessId();
    if (!Objects.areEqual(actualBpmnProcessId, bpmnProcessId)) {
      failWithMessage(assertjErrorMessage, actual, bpmnProcessId, actualBpmnProcessId);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual MessageStartEventSubscriptionRecordValue's correlationKey is equal to the given one.
   * @param correlationKey the given correlationKey to compare the actual MessageStartEventSubscriptionRecordValue's correlationKey to.
   * @return this assertion object.
   * @throws AssertionError - if the actual MessageStartEventSubscriptionRecordValue's correlationKey is not equal to the given one.
   */
  public S hasCorrelationKey(String correlationKey) {
    // check that actual MessageStartEventSubscriptionRecordValue we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting correlationKey of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // null safe check
    String actualCorrelationKey = actual.getCorrelationKey();
    if (!Objects.areEqual(actualCorrelationKey, correlationKey)) {
      failWithMessage(assertjErrorMessage, actual, correlationKey, actualCorrelationKey);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual MessageStartEventSubscriptionRecordValue's messageKey is equal to the given one.
   * @param messageKey the given messageKey to compare the actual MessageStartEventSubscriptionRecordValue's messageKey to.
   * @return this assertion object.
   * @throws AssertionError - if the actual MessageStartEventSubscriptionRecordValue's messageKey is not equal to the given one.
   */
  public S hasMessageKey(long messageKey) {
    // check that actual MessageStartEventSubscriptionRecordValue we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting messageKey of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // check
    long actualMessageKey = actual.getMessageKey();
    if (actualMessageKey != messageKey) {
      failWithMessage(assertjErrorMessage, actual, messageKey, actualMessageKey);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual MessageStartEventSubscriptionRecordValue's messageName is equal to the given one.
   * @param messageName the given messageName to compare the actual MessageStartEventSubscriptionRecordValue's messageName to.
   * @return this assertion object.
   * @throws AssertionError - if the actual MessageStartEventSubscriptionRecordValue's messageName is not equal to the given one.
   */
  public S hasMessageName(String messageName) {
    // check that actual MessageStartEventSubscriptionRecordValue we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting messageName of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // null safe check
    String actualMessageName = actual.getMessageName();
    if (!Objects.areEqual(actualMessageName, messageName)) {
      failWithMessage(assertjErrorMessage, actual, messageName, actualMessageName);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual MessageStartEventSubscriptionRecordValue's processDefinitionKey is equal to the given one.
   * @param processDefinitionKey the given processDefinitionKey to compare the actual MessageStartEventSubscriptionRecordValue's processDefinitionKey to.
   * @return this assertion object.
   * @throws AssertionError - if the actual MessageStartEventSubscriptionRecordValue's processDefinitionKey is not equal to the given one.
   */
  public S hasProcessDefinitionKey(long processDefinitionKey) {
    // check that actual MessageStartEventSubscriptionRecordValue we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting processDefinitionKey of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // check
    long actualProcessDefinitionKey = actual.getProcessDefinitionKey();
    if (actualProcessDefinitionKey != processDefinitionKey) {
      failWithMessage(assertjErrorMessage, actual, processDefinitionKey, actualProcessDefinitionKey);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual MessageStartEventSubscriptionRecordValue's processInstanceKey is equal to the given one.
   * @param processInstanceKey the given processInstanceKey to compare the actual MessageStartEventSubscriptionRecordValue's processInstanceKey to.
   * @return this assertion object.
   * @throws AssertionError - if the actual MessageStartEventSubscriptionRecordValue's processInstanceKey is not equal to the given one.
   */
  public S hasProcessInstanceKey(long processInstanceKey) {
    // check that actual MessageStartEventSubscriptionRecordValue we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting processInstanceKey of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // check
    long actualProcessInstanceKey = actual.getProcessInstanceKey();
    if (actualProcessInstanceKey != processInstanceKey) {
      failWithMessage(assertjErrorMessage, actual, processInstanceKey, actualProcessInstanceKey);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual MessageStartEventSubscriptionRecordValue's startEventId is equal to the given one.
   * @param startEventId the given startEventId to compare the actual MessageStartEventSubscriptionRecordValue's startEventId to.
   * @return this assertion object.
   * @throws AssertionError - if the actual MessageStartEventSubscriptionRecordValue's startEventId is not equal to the given one.
   */
  public S hasStartEventId(String startEventId) {
    // check that actual MessageStartEventSubscriptionRecordValue we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting startEventId of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // null safe check
    String actualStartEventId = actual.getStartEventId();
    if (!Objects.areEqual(actualStartEventId, startEventId)) {
      failWithMessage(assertjErrorMessage, actual, startEventId, actualStartEventId);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
