package io.camunda.zeebe.protocol.record.value;

import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link MessageRecordValue} specific assertions - Generated by CustomAssertionGenerator.
 */
@javax.annotation.Generated(value="assertj-assertions-generator")
public abstract class AbstractMessageRecordValueAssert<S extends AbstractMessageRecordValueAssert<S, A>, A extends MessageRecordValue> extends AbstractObjectAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractMessageRecordValueAssert}</code> to make assertions on actual MessageRecordValue.
   * @param actual the MessageRecordValue we want to make assertions on.
   */
  protected AbstractMessageRecordValueAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual MessageRecordValue's correlationKey is equal to the given one.
   * @param correlationKey the given correlationKey to compare the actual MessageRecordValue's correlationKey to.
   * @return this assertion object.
   * @throws AssertionError - if the actual MessageRecordValue's correlationKey is not equal to the given one.
   */
  public S hasCorrelationKey(String correlationKey) {
    // check that actual MessageRecordValue we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting correlationKey of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // null safe check
    String actualCorrelationKey = actual.getCorrelationKey();
    if (!Objects.areEqual(actualCorrelationKey, correlationKey)) {
      failWithMessage(assertjErrorMessage, actual, correlationKey, actualCorrelationKey);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual MessageRecordValue's deadline is equal to the given one.
   * @param deadline the given deadline to compare the actual MessageRecordValue's deadline to.
   * @return this assertion object.
   * @throws AssertionError - if the actual MessageRecordValue's deadline is not equal to the given one.
   */
  public S hasDeadline(long deadline) {
    // check that actual MessageRecordValue we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting deadline of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // check
    long actualDeadline = actual.getDeadline();
    if (actualDeadline != deadline) {
      failWithMessage(assertjErrorMessage, actual, deadline, actualDeadline);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual MessageRecordValue's messageId is equal to the given one.
   * @param messageId the given messageId to compare the actual MessageRecordValue's messageId to.
   * @return this assertion object.
   * @throws AssertionError - if the actual MessageRecordValue's messageId is not equal to the given one.
   */
  public S hasMessageId(String messageId) {
    // check that actual MessageRecordValue we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting messageId of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // null safe check
    String actualMessageId = actual.getMessageId();
    if (!Objects.areEqual(actualMessageId, messageId)) {
      failWithMessage(assertjErrorMessage, actual, messageId, actualMessageId);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual MessageRecordValue's name is equal to the given one.
   * @param name the given name to compare the actual MessageRecordValue's name to.
   * @return this assertion object.
   * @throws AssertionError - if the actual MessageRecordValue's name is not equal to the given one.
   */
  public S hasName(String name) {
    // check that actual MessageRecordValue we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting name of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // null safe check
    String actualName = actual.getName();
    if (!Objects.areEqual(actualName, name)) {
      failWithMessage(assertjErrorMessage, actual, name, actualName);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual MessageRecordValue's timeToLive is equal to the given one.
   * @param timeToLive the given timeToLive to compare the actual MessageRecordValue's timeToLive to.
   * @return this assertion object.
   * @throws AssertionError - if the actual MessageRecordValue's timeToLive is not equal to the given one.
   */
  public S hasTimeToLive(long timeToLive) {
    // check that actual MessageRecordValue we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting timeToLive of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // check
    long actualTimeToLive = actual.getTimeToLive();
    if (actualTimeToLive != timeToLive) {
      failWithMessage(assertjErrorMessage, actual, timeToLive, actualTimeToLive);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
