package io.camunda.zeebe.protocol.record.value;

import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link JobRecordValue} specific assertions - Generated by CustomAssertionGenerator.
 */
@javax.annotation.Generated(value="assertj-assertions-generator")
public abstract class AbstractJobRecordValueAssert<S extends AbstractJobRecordValueAssert<S, A>, A extends JobRecordValue> extends AbstractObjectAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractJobRecordValueAssert}</code> to make assertions on actual JobRecordValue.
   * @param actual the JobRecordValue we want to make assertions on.
   */
  protected AbstractJobRecordValueAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual JobRecordValue's bpmnProcessId is equal to the given one.
   * @param bpmnProcessId the given bpmnProcessId to compare the actual JobRecordValue's bpmnProcessId to.
   * @return this assertion object.
   * @throws AssertionError - if the actual JobRecordValue's bpmnProcessId is not equal to the given one.
   */
  public S hasBpmnProcessId(String bpmnProcessId) {
    // check that actual JobRecordValue we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting bpmnProcessId of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // null safe check
    String actualBpmnProcessId = actual.getBpmnProcessId();
    if (!Objects.areEqual(actualBpmnProcessId, bpmnProcessId)) {
      failWithMessage(assertjErrorMessage, actual, bpmnProcessId, actualBpmnProcessId);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual JobRecordValue's customHeaders is equal to the given one.
   * @param customHeaders the given customHeaders to compare the actual JobRecordValue's customHeaders to.
   * @return this assertion object.
   * @throws AssertionError - if the actual JobRecordValue's customHeaders is not equal to the given one.
   */
  public S hasCustomHeaders(java.util.Map customHeaders) {
    // check that actual JobRecordValue we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting customHeaders of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // null safe check
    java.util.Map actualCustomHeaders = actual.getCustomHeaders();
    if (!Objects.areEqual(actualCustomHeaders, customHeaders)) {
      failWithMessage(assertjErrorMessage, actual, customHeaders, actualCustomHeaders);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual JobRecordValue's deadline is equal to the given one.
   * @param deadline the given deadline to compare the actual JobRecordValue's deadline to.
   * @return this assertion object.
   * @throws AssertionError - if the actual JobRecordValue's deadline is not equal to the given one.
   */
  public S hasDeadline(long deadline) {
    // check that actual JobRecordValue we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting deadline of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // check
    long actualDeadline = actual.getDeadline();
    if (actualDeadline != deadline) {
      failWithMessage(assertjErrorMessage, actual, deadline, actualDeadline);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual JobRecordValue's elementId is equal to the given one.
   * @param elementId the given elementId to compare the actual JobRecordValue's elementId to.
   * @return this assertion object.
   * @throws AssertionError - if the actual JobRecordValue's elementId is not equal to the given one.
   */
  public S hasElementId(String elementId) {
    // check that actual JobRecordValue we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting elementId of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // null safe check
    String actualElementId = actual.getElementId();
    if (!Objects.areEqual(actualElementId, elementId)) {
      failWithMessage(assertjErrorMessage, actual, elementId, actualElementId);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual JobRecordValue's elementInstanceKey is equal to the given one.
   * @param elementInstanceKey the given elementInstanceKey to compare the actual JobRecordValue's elementInstanceKey to.
   * @return this assertion object.
   * @throws AssertionError - if the actual JobRecordValue's elementInstanceKey is not equal to the given one.
   */
  public S hasElementInstanceKey(long elementInstanceKey) {
    // check that actual JobRecordValue we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting elementInstanceKey of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // check
    long actualElementInstanceKey = actual.getElementInstanceKey();
    if (actualElementInstanceKey != elementInstanceKey) {
      failWithMessage(assertjErrorMessage, actual, elementInstanceKey, actualElementInstanceKey);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual JobRecordValue's errorCode is equal to the given one.
   * @param errorCode the given errorCode to compare the actual JobRecordValue's errorCode to.
   * @return this assertion object.
   * @throws AssertionError - if the actual JobRecordValue's errorCode is not equal to the given one.
   */
  public S hasErrorCode(String errorCode) {
    // check that actual JobRecordValue we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting errorCode of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // null safe check
    String actualErrorCode = actual.getErrorCode();
    if (!Objects.areEqual(actualErrorCode, errorCode)) {
      failWithMessage(assertjErrorMessage, actual, errorCode, actualErrorCode);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual JobRecordValue's errorMessage is equal to the given one.
   * @param errorMessage the given errorMessage to compare the actual JobRecordValue's errorMessage to.
   * @return this assertion object.
   * @throws AssertionError - if the actual JobRecordValue's errorMessage is not equal to the given one.
   */
  public S hasErrorMessage(String errorMessage) {
    // check that actual JobRecordValue we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting errorMessage of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // null safe check
    String actualErrorMessage = actual.getErrorMessage();
    if (!Objects.areEqual(actualErrorMessage, errorMessage)) {
      failWithMessage(assertjErrorMessage, actual, errorMessage, actualErrorMessage);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual JobRecordValue's processDefinitionKey is equal to the given one.
   * @param processDefinitionKey the given processDefinitionKey to compare the actual JobRecordValue's processDefinitionKey to.
   * @return this assertion object.
   * @throws AssertionError - if the actual JobRecordValue's processDefinitionKey is not equal to the given one.
   */
  public S hasProcessDefinitionKey(long processDefinitionKey) {
    // check that actual JobRecordValue we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting processDefinitionKey of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // check
    long actualProcessDefinitionKey = actual.getProcessDefinitionKey();
    if (actualProcessDefinitionKey != processDefinitionKey) {
      failWithMessage(assertjErrorMessage, actual, processDefinitionKey, actualProcessDefinitionKey);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual JobRecordValue's processDefinitionVersion is equal to the given one.
   * @param processDefinitionVersion the given processDefinitionVersion to compare the actual JobRecordValue's processDefinitionVersion to.
   * @return this assertion object.
   * @throws AssertionError - if the actual JobRecordValue's processDefinitionVersion is not equal to the given one.
   */
  public S hasProcessDefinitionVersion(int processDefinitionVersion) {
    // check that actual JobRecordValue we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting processDefinitionVersion of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // check
    int actualProcessDefinitionVersion = actual.getProcessDefinitionVersion();
    if (actualProcessDefinitionVersion != processDefinitionVersion) {
      failWithMessage(assertjErrorMessage, actual, processDefinitionVersion, actualProcessDefinitionVersion);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual JobRecordValue's retries is equal to the given one.
   * @param retries the given retries to compare the actual JobRecordValue's retries to.
   * @return this assertion object.
   * @throws AssertionError - if the actual JobRecordValue's retries is not equal to the given one.
   */
  public S hasRetries(int retries) {
    // check that actual JobRecordValue we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting retries of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // check
    int actualRetries = actual.getRetries();
    if (actualRetries != retries) {
      failWithMessage(assertjErrorMessage, actual, retries, actualRetries);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual JobRecordValue's type is equal to the given one.
   * @param type the given type to compare the actual JobRecordValue's type to.
   * @return this assertion object.
   * @throws AssertionError - if the actual JobRecordValue's type is not equal to the given one.
   */
  public S hasType(String type) {
    // check that actual JobRecordValue we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting type of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // null safe check
    String actualType = actual.getType();
    if (!Objects.areEqual(actualType, type)) {
      failWithMessage(assertjErrorMessage, actual, type, actualType);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual JobRecordValue's worker is equal to the given one.
   * @param worker the given worker to compare the actual JobRecordValue's worker to.
   * @return this assertion object.
   * @throws AssertionError - if the actual JobRecordValue's worker is not equal to the given one.
   */
  public S hasWorker(String worker) {
    // check that actual JobRecordValue we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting worker of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // null safe check
    String actualWorker = actual.getWorker();
    if (!Objects.areEqual(actualWorker, worker)) {
      failWithMessage(assertjErrorMessage, actual, worker, actualWorker);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
