package io.camunda.zeebe.protocol.record.value;

import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link JobBatchRecordValue} specific assertions - Generated by CustomAssertionGenerator.
 */
@javax.annotation.Generated(value="assertj-assertions-generator")
public abstract class AbstractJobBatchRecordValueAssert<S extends AbstractJobBatchRecordValueAssert<S, A>, A extends JobBatchRecordValue> extends AbstractObjectAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractJobBatchRecordValueAssert}</code> to make assertions on actual JobBatchRecordValue.
   * @param actual the JobBatchRecordValue we want to make assertions on.
   */
  protected AbstractJobBatchRecordValueAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual JobBatchRecordValue's jobKeys contains the given Long elements.
   * @param jobKeys the given elements that should be contained in actual JobBatchRecordValue's jobKeys.
   * @return this assertion object.
   * @throws AssertionError if the actual JobBatchRecordValue's jobKeys does not contain all given Long elements.
   */
  public S hasJobKeys(Long... jobKeys) {
    // check that actual JobBatchRecordValue we want to make assertions on is not null.
    isNotNull();

    // check that given Long varargs is not null.
    if (jobKeys == null) failWithMessage("Expecting jobKeys parameter not to be null.");

    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getJobKeys(), jobKeys);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual JobBatchRecordValue's jobKeys contains the given Long elements in Collection.
   * @param jobKeys the given elements that should be contained in actual JobBatchRecordValue's jobKeys.
   * @return this assertion object.
   * @throws AssertionError if the actual JobBatchRecordValue's jobKeys does not contain all given Long elements.
   */
  public S hasJobKeys(java.util.Collection<? extends Long> jobKeys) {
    // check that actual JobBatchRecordValue we want to make assertions on is not null.
    isNotNull();

    // check that given Long collection is not null.
    if (jobKeys == null) {
      failWithMessage("Expecting jobKeys parameter not to be null.");
      return myself; // to fool Eclipse "Null pointer access" warning on toArray.
    }

    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getJobKeys(), jobKeys.toArray());

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual JobBatchRecordValue's jobKeys contains <b>only</b> the given Long elements and nothing else in whatever order.
   * @param jobKeys the given elements that should be contained in actual JobBatchRecordValue's jobKeys.
   * @return this assertion object.
   * @throws AssertionError if the actual JobBatchRecordValue's jobKeys does not contain all given Long elements.
   */
  public S hasOnlyJobKeys(Long... jobKeys) {
    // check that actual JobBatchRecordValue we want to make assertions on is not null.
    isNotNull();

    // check that given Long varargs is not null.
    if (jobKeys == null) failWithMessage("Expecting jobKeys parameter not to be null.");

    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.getJobKeys(), jobKeys);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual JobBatchRecordValue's jobKeys contains <b>only</b> the given Long elements in Collection and nothing else in whatever order.
   * @param jobKeys the given elements that should be contained in actual JobBatchRecordValue's jobKeys.
   * @return this assertion object.
   * @throws AssertionError if the actual JobBatchRecordValue's jobKeys does not contain all given Long elements.
   */
  public S hasOnlyJobKeys(java.util.Collection<? extends Long> jobKeys) {
    // check that actual JobBatchRecordValue we want to make assertions on is not null.
    isNotNull();

    // check that given Long collection is not null.
    if (jobKeys == null) {
      failWithMessage("Expecting jobKeys parameter not to be null.");
      return myself; // to fool Eclipse "Null pointer access" warning on toArray.
    }

    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.getJobKeys(), jobKeys.toArray());

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual JobBatchRecordValue's jobKeys does not contain the given Long elements.
   *
   * @param jobKeys the given elements that should not be in actual JobBatchRecordValue's jobKeys.
   * @return this assertion object.
   * @throws AssertionError if the actual JobBatchRecordValue's jobKeys contains any given Long elements.
   */
  public S doesNotHaveJobKeys(Long... jobKeys) {
    // check that actual JobBatchRecordValue we want to make assertions on is not null.
    isNotNull();

    // check that given Long varargs is not null.
    if (jobKeys == null) failWithMessage("Expecting jobKeys parameter not to be null.");

    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.getJobKeys(), jobKeys);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual JobBatchRecordValue's jobKeys does not contain the given Long elements in Collection.
   *
   * @param jobKeys the given elements that should not be in actual JobBatchRecordValue's jobKeys.
   * @return this assertion object.
   * @throws AssertionError if the actual JobBatchRecordValue's jobKeys contains any given Long elements.
   */
  public S doesNotHaveJobKeys(java.util.Collection<? extends Long> jobKeys) {
    // check that actual JobBatchRecordValue we want to make assertions on is not null.
    isNotNull();

    // check that given Long collection is not null.
    if (jobKeys == null) {
      failWithMessage("Expecting jobKeys parameter not to be null.");
      return myself; // to fool Eclipse "Null pointer access" warning on toArray.
    }

    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.getJobKeys(), jobKeys.toArray());

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual JobBatchRecordValue has no jobKeys.
   * @return this assertion object.
   * @throws AssertionError if the actual JobBatchRecordValue's jobKeys is not empty.
   */
  public S hasNoJobKeys() {
    // check that actual JobBatchRecordValue we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have jobKeys but had :\n  <%s>";

    // check
    if (actual.getJobKeys().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getJobKeys());
    }

    // return the current assertion for method chaining
    return myself;
  }


  /**
   * Verifies that the actual JobBatchRecordValue's jobs contains the given JobRecordValue elements.
   * @param jobs the given elements that should be contained in actual JobBatchRecordValue's jobs.
   * @return this assertion object.
   * @throws AssertionError if the actual JobBatchRecordValue's jobs does not contain all given JobRecordValue elements.
   */
  public S hasJobs(JobRecordValue... jobs) {
    // check that actual JobBatchRecordValue we want to make assertions on is not null.
    isNotNull();

    // check that given JobRecordValue varargs is not null.
    if (jobs == null) failWithMessage("Expecting jobs parameter not to be null.");

    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getJobs(), jobs);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual JobBatchRecordValue's jobs contains the given JobRecordValue elements in Collection.
   * @param jobs the given elements that should be contained in actual JobBatchRecordValue's jobs.
   * @return this assertion object.
   * @throws AssertionError if the actual JobBatchRecordValue's jobs does not contain all given JobRecordValue elements.
   */
  public S hasJobs(java.util.Collection<? extends JobRecordValue> jobs) {
    // check that actual JobBatchRecordValue we want to make assertions on is not null.
    isNotNull();

    // check that given JobRecordValue collection is not null.
    if (jobs == null) {
      failWithMessage("Expecting jobs parameter not to be null.");
      return myself; // to fool Eclipse "Null pointer access" warning on toArray.
    }

    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getJobs(), jobs.toArray());

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual JobBatchRecordValue's jobs contains <b>only</b> the given JobRecordValue elements and nothing else in whatever order.
   * @param jobs the given elements that should be contained in actual JobBatchRecordValue's jobs.
   * @return this assertion object.
   * @throws AssertionError if the actual JobBatchRecordValue's jobs does not contain all given JobRecordValue elements.
   */
  public S hasOnlyJobs(JobRecordValue... jobs) {
    // check that actual JobBatchRecordValue we want to make assertions on is not null.
    isNotNull();

    // check that given JobRecordValue varargs is not null.
    if (jobs == null) failWithMessage("Expecting jobs parameter not to be null.");

    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.getJobs(), jobs);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual JobBatchRecordValue's jobs contains <b>only</b> the given JobRecordValue elements in Collection and nothing else in whatever order.
   * @param jobs the given elements that should be contained in actual JobBatchRecordValue's jobs.
   * @return this assertion object.
   * @throws AssertionError if the actual JobBatchRecordValue's jobs does not contain all given JobRecordValue elements.
   */
  public S hasOnlyJobs(java.util.Collection<? extends JobRecordValue> jobs) {
    // check that actual JobBatchRecordValue we want to make assertions on is not null.
    isNotNull();

    // check that given JobRecordValue collection is not null.
    if (jobs == null) {
      failWithMessage("Expecting jobs parameter not to be null.");
      return myself; // to fool Eclipse "Null pointer access" warning on toArray.
    }

    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.getJobs(), jobs.toArray());

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual JobBatchRecordValue's jobs does not contain the given JobRecordValue elements.
   *
   * @param jobs the given elements that should not be in actual JobBatchRecordValue's jobs.
   * @return this assertion object.
   * @throws AssertionError if the actual JobBatchRecordValue's jobs contains any given JobRecordValue elements.
   */
  public S doesNotHaveJobs(JobRecordValue... jobs) {
    // check that actual JobBatchRecordValue we want to make assertions on is not null.
    isNotNull();

    // check that given JobRecordValue varargs is not null.
    if (jobs == null) failWithMessage("Expecting jobs parameter not to be null.");

    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.getJobs(), jobs);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual JobBatchRecordValue's jobs does not contain the given JobRecordValue elements in Collection.
   *
   * @param jobs the given elements that should not be in actual JobBatchRecordValue's jobs.
   * @return this assertion object.
   * @throws AssertionError if the actual JobBatchRecordValue's jobs contains any given JobRecordValue elements.
   */
  public S doesNotHaveJobs(java.util.Collection<? extends JobRecordValue> jobs) {
    // check that actual JobBatchRecordValue we want to make assertions on is not null.
    isNotNull();

    // check that given JobRecordValue collection is not null.
    if (jobs == null) {
      failWithMessage("Expecting jobs parameter not to be null.");
      return myself; // to fool Eclipse "Null pointer access" warning on toArray.
    }

    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.getJobs(), jobs.toArray());

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual JobBatchRecordValue has no jobs.
   * @return this assertion object.
   * @throws AssertionError if the actual JobBatchRecordValue's jobs is not empty.
   */
  public S hasNoJobs() {
    // check that actual JobBatchRecordValue we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have jobs but had :\n  <%s>";

    // check
    if (actual.getJobs().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getJobs());
    }

    // return the current assertion for method chaining
    return myself;
  }


  /**
   * Verifies that the actual JobBatchRecordValue's maxJobsToActivate is equal to the given one.
   * @param maxJobsToActivate the given maxJobsToActivate to compare the actual JobBatchRecordValue's maxJobsToActivate to.
   * @return this assertion object.
   * @throws AssertionError - if the actual JobBatchRecordValue's maxJobsToActivate is not equal to the given one.
   */
  public S hasMaxJobsToActivate(int maxJobsToActivate) {
    // check that actual JobBatchRecordValue we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting maxJobsToActivate of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // check
    int actualMaxJobsToActivate = actual.getMaxJobsToActivate();
    if (actualMaxJobsToActivate != maxJobsToActivate) {
      failWithMessage(assertjErrorMessage, actual, maxJobsToActivate, actualMaxJobsToActivate);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual JobBatchRecordValue's timeout is equal to the given one.
   * @param timeout the given timeout to compare the actual JobBatchRecordValue's timeout to.
   * @return this assertion object.
   * @throws AssertionError - if the actual JobBatchRecordValue's timeout is not equal to the given one.
   */
  public S hasTimeout(long timeout) {
    // check that actual JobBatchRecordValue we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting timeout of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // check
    long actualTimeout = actual.getTimeout();
    if (actualTimeout != timeout) {
      failWithMessage(assertjErrorMessage, actual, timeout, actualTimeout);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual JobBatchRecordValue is truncated.
   * @return this assertion object.
   * @throws AssertionError - if the actual JobBatchRecordValue is not truncated.
   */
  public S isTruncated() {
    // check that actual JobBatchRecordValue we want to make assertions on is not null.
    isNotNull();

    // check that property call/field access is true
    if (!actual.isTruncated()) {
      failWithMessage("\nExpecting that actual JobBatchRecordValue is truncated but is not.");
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual JobBatchRecordValue is not truncated.
   * @return this assertion object.
   * @throws AssertionError - if the actual JobBatchRecordValue is truncated.
   */
  public S isNotTruncated() {
    // check that actual JobBatchRecordValue we want to make assertions on is not null.
    isNotNull();

    // check that property call/field access is false
    if (actual.isTruncated()) {
      failWithMessage("\nExpecting that actual JobBatchRecordValue is not truncated but is.");
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual JobBatchRecordValue's type is equal to the given one.
   * @param type the given type to compare the actual JobBatchRecordValue's type to.
   * @return this assertion object.
   * @throws AssertionError - if the actual JobBatchRecordValue's type is not equal to the given one.
   */
  public S hasType(String type) {
    // check that actual JobBatchRecordValue we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting type of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // null safe check
    String actualType = actual.getType();
    if (!Objects.areEqual(actualType, type)) {
      failWithMessage(assertjErrorMessage, actual, type, actualType);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual JobBatchRecordValue's worker is equal to the given one.
   * @param worker the given worker to compare the actual JobBatchRecordValue's worker to.
   * @return this assertion object.
   * @throws AssertionError - if the actual JobBatchRecordValue's worker is not equal to the given one.
   */
  public S hasWorker(String worker) {
    // check that actual JobBatchRecordValue we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting worker of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // null safe check
    String actualWorker = actual.getWorker();
    if (!Objects.areEqual(actualWorker, worker)) {
      failWithMessage(assertjErrorMessage, actual, worker, actualWorker);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
