package io.camunda.zeebe.protocol.record.value;

import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link IncidentRecordValue} specific assertions - Generated by CustomAssertionGenerator.
 */
@javax.annotation.Generated(value="assertj-assertions-generator")
public abstract class AbstractIncidentRecordValueAssert<S extends AbstractIncidentRecordValueAssert<S, A>, A extends IncidentRecordValue> extends AbstractObjectAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractIncidentRecordValueAssert}</code> to make assertions on actual IncidentRecordValue.
   * @param actual the IncidentRecordValue we want to make assertions on.
   */
  protected AbstractIncidentRecordValueAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual IncidentRecordValue's bpmnProcessId is equal to the given one.
   * @param bpmnProcessId the given bpmnProcessId to compare the actual IncidentRecordValue's bpmnProcessId to.
   * @return this assertion object.
   * @throws AssertionError - if the actual IncidentRecordValue's bpmnProcessId is not equal to the given one.
   */
  public S hasBpmnProcessId(String bpmnProcessId) {
    // check that actual IncidentRecordValue we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting bpmnProcessId of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // null safe check
    String actualBpmnProcessId = actual.getBpmnProcessId();
    if (!Objects.areEqual(actualBpmnProcessId, bpmnProcessId)) {
      failWithMessage(assertjErrorMessage, actual, bpmnProcessId, actualBpmnProcessId);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual IncidentRecordValue's elementId is equal to the given one.
   * @param elementId the given elementId to compare the actual IncidentRecordValue's elementId to.
   * @return this assertion object.
   * @throws AssertionError - if the actual IncidentRecordValue's elementId is not equal to the given one.
   */
  public S hasElementId(String elementId) {
    // check that actual IncidentRecordValue we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting elementId of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // null safe check
    String actualElementId = actual.getElementId();
    if (!Objects.areEqual(actualElementId, elementId)) {
      failWithMessage(assertjErrorMessage, actual, elementId, actualElementId);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual IncidentRecordValue's elementInstanceKey is equal to the given one.
   * @param elementInstanceKey the given elementInstanceKey to compare the actual IncidentRecordValue's elementInstanceKey to.
   * @return this assertion object.
   * @throws AssertionError - if the actual IncidentRecordValue's elementInstanceKey is not equal to the given one.
   */
  public S hasElementInstanceKey(long elementInstanceKey) {
    // check that actual IncidentRecordValue we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting elementInstanceKey of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // check
    long actualElementInstanceKey = actual.getElementInstanceKey();
    if (actualElementInstanceKey != elementInstanceKey) {
      failWithMessage(assertjErrorMessage, actual, elementInstanceKey, actualElementInstanceKey);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual IncidentRecordValue's errorMessage is equal to the given one.
   * @param errorMessage the given errorMessage to compare the actual IncidentRecordValue's errorMessage to.
   * @return this assertion object.
   * @throws AssertionError - if the actual IncidentRecordValue's errorMessage is not equal to the given one.
   */
  public S hasErrorMessage(String errorMessage) {
    // check that actual IncidentRecordValue we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting errorMessage of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // null safe check
    String actualErrorMessage = actual.getErrorMessage();
    if (!Objects.areEqual(actualErrorMessage, errorMessage)) {
      failWithMessage(assertjErrorMessage, actual, errorMessage, actualErrorMessage);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual IncidentRecordValue's errorType is equal to the given one.
   * @param errorType the given errorType to compare the actual IncidentRecordValue's errorType to.
   * @return this assertion object.
   * @throws AssertionError - if the actual IncidentRecordValue's errorType is not equal to the given one.
   */
  public S hasErrorType(ErrorType errorType) {
    // check that actual IncidentRecordValue we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting errorType of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // null safe check
    ErrorType actualErrorType = actual.getErrorType();
    if (!Objects.areEqual(actualErrorType, errorType)) {
      failWithMessage(assertjErrorMessage, actual, errorType, actualErrorType);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual IncidentRecordValue's jobKey is equal to the given one.
   * @param jobKey the given jobKey to compare the actual IncidentRecordValue's jobKey to.
   * @return this assertion object.
   * @throws AssertionError - if the actual IncidentRecordValue's jobKey is not equal to the given one.
   */
  public S hasJobKey(long jobKey) {
    // check that actual IncidentRecordValue we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting jobKey of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // check
    long actualJobKey = actual.getJobKey();
    if (actualJobKey != jobKey) {
      failWithMessage(assertjErrorMessage, actual, jobKey, actualJobKey);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual IncidentRecordValue's processDefinitionKey is equal to the given one.
   * @param processDefinitionKey the given processDefinitionKey to compare the actual IncidentRecordValue's processDefinitionKey to.
   * @return this assertion object.
   * @throws AssertionError - if the actual IncidentRecordValue's processDefinitionKey is not equal to the given one.
   */
  public S hasProcessDefinitionKey(long processDefinitionKey) {
    // check that actual IncidentRecordValue we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting processDefinitionKey of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // check
    long actualProcessDefinitionKey = actual.getProcessDefinitionKey();
    if (actualProcessDefinitionKey != processDefinitionKey) {
      failWithMessage(assertjErrorMessage, actual, processDefinitionKey, actualProcessDefinitionKey);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual IncidentRecordValue's processInstanceKey is equal to the given one.
   * @param processInstanceKey the given processInstanceKey to compare the actual IncidentRecordValue's processInstanceKey to.
   * @return this assertion object.
   * @throws AssertionError - if the actual IncidentRecordValue's processInstanceKey is not equal to the given one.
   */
  public S hasProcessInstanceKey(long processInstanceKey) {
    // check that actual IncidentRecordValue we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting processInstanceKey of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // check
    long actualProcessInstanceKey = actual.getProcessInstanceKey();
    if (actualProcessInstanceKey != processInstanceKey) {
      failWithMessage(assertjErrorMessage, actual, processInstanceKey, actualProcessInstanceKey);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual IncidentRecordValue's variableScopeKey is equal to the given one.
   * @param variableScopeKey the given variableScopeKey to compare the actual IncidentRecordValue's variableScopeKey to.
   * @return this assertion object.
   * @throws AssertionError - if the actual IncidentRecordValue's variableScopeKey is not equal to the given one.
   */
  public S hasVariableScopeKey(long variableScopeKey) {
    // check that actual IncidentRecordValue we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting variableScopeKey of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // check
    long actualVariableScopeKey = actual.getVariableScopeKey();
    if (actualVariableScopeKey != variableScopeKey) {
      failWithMessage(assertjErrorMessage, actual, variableScopeKey, actualVariableScopeKey);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
