package io.camunda.zeebe.protocol.record.value;

import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link ErrorRecordValue} specific assertions - Generated by CustomAssertionGenerator.
 */
@javax.annotation.Generated(value="assertj-assertions-generator")
public abstract class AbstractErrorRecordValueAssert<S extends AbstractErrorRecordValueAssert<S, A>, A extends ErrorRecordValue> extends AbstractObjectAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractErrorRecordValueAssert}</code> to make assertions on actual ErrorRecordValue.
   * @param actual the ErrorRecordValue we want to make assertions on.
   */
  protected AbstractErrorRecordValueAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual ErrorRecordValue's errorEventPosition is equal to the given one.
   * @param errorEventPosition the given errorEventPosition to compare the actual ErrorRecordValue's errorEventPosition to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ErrorRecordValue's errorEventPosition is not equal to the given one.
   */
  public S hasErrorEventPosition(long errorEventPosition) {
    // check that actual ErrorRecordValue we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting errorEventPosition of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // check
    long actualErrorEventPosition = actual.getErrorEventPosition();
    if (actualErrorEventPosition != errorEventPosition) {
      failWithMessage(assertjErrorMessage, actual, errorEventPosition, actualErrorEventPosition);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ErrorRecordValue's exceptionMessage is equal to the given one.
   * @param exceptionMessage the given exceptionMessage to compare the actual ErrorRecordValue's exceptionMessage to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ErrorRecordValue's exceptionMessage is not equal to the given one.
   */
  public S hasExceptionMessage(String exceptionMessage) {
    // check that actual ErrorRecordValue we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting exceptionMessage of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // null safe check
    String actualExceptionMessage = actual.getExceptionMessage();
    if (!Objects.areEqual(actualExceptionMessage, exceptionMessage)) {
      failWithMessage(assertjErrorMessage, actual, exceptionMessage, actualExceptionMessage);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ErrorRecordValue's processInstanceKey is equal to the given one.
   * @param processInstanceKey the given processInstanceKey to compare the actual ErrorRecordValue's processInstanceKey to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ErrorRecordValue's processInstanceKey is not equal to the given one.
   */
  public S hasProcessInstanceKey(long processInstanceKey) {
    // check that actual ErrorRecordValue we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting processInstanceKey of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // check
    long actualProcessInstanceKey = actual.getProcessInstanceKey();
    if (actualProcessInstanceKey != processInstanceKey) {
      failWithMessage(assertjErrorMessage, actual, processInstanceKey, actualProcessInstanceKey);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ErrorRecordValue's stacktrace is equal to the given one.
   * @param stacktrace the given stacktrace to compare the actual ErrorRecordValue's stacktrace to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ErrorRecordValue's stacktrace is not equal to the given one.
   */
  public S hasStacktrace(String stacktrace) {
    // check that actual ErrorRecordValue we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting stacktrace of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // null safe check
    String actualStacktrace = actual.getStacktrace();
    if (!Objects.areEqual(actualStacktrace, stacktrace)) {
      failWithMessage(assertjErrorMessage, actual, stacktrace, actualStacktrace);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
