package io.camunda.zeebe.protocol.record.value;

import org.assertj.core.api.AbstractObjectAssert;

/**
 * Abstract base class for {@link DeploymentDistributionRecordValue} specific assertions - Generated by CustomAssertionGenerator.
 */
@javax.annotation.Generated(value="assertj-assertions-generator")
public abstract class AbstractDeploymentDistributionRecordValueAssert<S extends AbstractDeploymentDistributionRecordValueAssert<S, A>, A extends DeploymentDistributionRecordValue> extends AbstractObjectAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractDeploymentDistributionRecordValueAssert}</code> to make assertions on actual DeploymentDistributionRecordValue.
   * @param actual the DeploymentDistributionRecordValue we want to make assertions on.
   */
  protected AbstractDeploymentDistributionRecordValueAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual DeploymentDistributionRecordValue's partitionId is equal to the given one.
   * @param partitionId the given partitionId to compare the actual DeploymentDistributionRecordValue's partitionId to.
   * @return this assertion object.
   * @throws AssertionError - if the actual DeploymentDistributionRecordValue's partitionId is not equal to the given one.
   */
  public S hasPartitionId(int partitionId) {
    // check that actual DeploymentDistributionRecordValue we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting partitionId of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // check
    int actualPartitionId = actual.getPartitionId();
    if (actualPartitionId != partitionId) {
      failWithMessage(assertjErrorMessage, actual, partitionId, actualPartitionId);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
