package io.camunda.zeebe.protocol.record.intent;

import org.assertj.core.api.AbstractComparableAssert;

/**
 * Abstract base class for {@link ProcessInstanceResultIntent} specific assertions - Generated by CustomAssertionGenerator.
 */
@javax.annotation.Generated(value="assertj-assertions-generator")
public abstract class AbstractProcessInstanceResultIntentAssert<S extends AbstractProcessInstanceResultIntentAssert<S, A>, A extends ProcessInstanceResultIntent> extends AbstractComparableAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractProcessInstanceResultIntentAssert}</code> to make assertions on actual ProcessInstanceResultIntent.
   * @param actual the ProcessInstanceResultIntent we want to make assertions on.
   */
  protected AbstractProcessInstanceResultIntentAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual ProcessInstanceResultIntent should blacklist instance on error.
   * @return this assertion object.
   * @throws AssertionError - if the actual ProcessInstanceResultIntent should not blacklist instance on error.
   */
  public S shouldBlacklistInstanceOnError() {
    // check that actual ProcessInstanceResultIntent we want to make assertions on is not null.
    isNotNull();

    // check that property call/field access is true
    if (!actual.shouldBlacklistInstanceOnError()) {
      failWithMessage("\nExpecting that actual ProcessInstanceResultIntent should blacklist instance on error but should not.");
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ProcessInstanceResultIntent should not blacklist instance on error.
   * @return this assertion object.
   * @throws AssertionError - if the actual ProcessInstanceResultIntent should blacklist instance on error.
   */
  public S shouldNotBlacklistInstanceOnError() {
    // check that actual ProcessInstanceResultIntent we want to make assertions on is not null.
    isNotNull();

    // check that property call/field access is false
    if (actual.shouldBlacklistInstanceOnError()) {
      failWithMessage("\nExpecting that actual ProcessInstanceResultIntent should not blacklist instance on error but should.");
    }

    // return the current assertion for method chaining
    return myself;
  }

}
