package io.camunda.zeebe.protocol.record.intent;

import org.assertj.core.api.AbstractObjectAssert;

/**
 * Abstract base class for {@link ProcessInstanceRelatedIntent} specific assertions - Generated by CustomAssertionGenerator.
 */
@javax.annotation.Generated(value="assertj-assertions-generator")
public abstract class AbstractProcessInstanceRelatedIntentAssert<S extends AbstractProcessInstanceRelatedIntentAssert<S, A>, A extends ProcessInstanceRelatedIntent> extends AbstractObjectAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractProcessInstanceRelatedIntentAssert}</code> to make assertions on actual ProcessInstanceRelatedIntent.
   * @param actual the ProcessInstanceRelatedIntent we want to make assertions on.
   */
  protected AbstractProcessInstanceRelatedIntentAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual ProcessInstanceRelatedIntent should blacklist instance on error.
   * @return this assertion object.
   * @throws AssertionError - if the actual ProcessInstanceRelatedIntent should not blacklist instance on error.
   */
  public S shouldBlacklistInstanceOnError() {
    // check that actual ProcessInstanceRelatedIntent we want to make assertions on is not null.
    isNotNull();

    // check that property call/field access is true
    if (!actual.shouldBlacklistInstanceOnError()) {
      failWithMessage("\nExpecting that actual ProcessInstanceRelatedIntent should blacklist instance on error but should not.");
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ProcessInstanceRelatedIntent should not blacklist instance on error.
   * @return this assertion object.
   * @throws AssertionError - if the actual ProcessInstanceRelatedIntent should blacklist instance on error.
   */
  public S shouldNotBlacklistInstanceOnError() {
    // check that actual ProcessInstanceRelatedIntent we want to make assertions on is not null.
    isNotNull();

    // check that property call/field access is false
    if (actual.shouldBlacklistInstanceOnError()) {
      failWithMessage("\nExpecting that actual ProcessInstanceRelatedIntent should not blacklist instance on error but should.");
    }

    // return the current assertion for method chaining
    return myself;
  }

}
