package io.camunda.zeebe.protocol.record.intent;

import org.assertj.core.api.AbstractComparableAssert;

/**
 * Abstract base class for {@link MessageSubscriptionIntent} specific assertions - Generated by CustomAssertionGenerator.
 */
@javax.annotation.Generated(value="assertj-assertions-generator")
public abstract class AbstractMessageSubscriptionIntentAssert<S extends AbstractMessageSubscriptionIntentAssert<S, A>, A extends MessageSubscriptionIntent> extends AbstractComparableAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractMessageSubscriptionIntentAssert}</code> to make assertions on actual MessageSubscriptionIntent.
   * @param actual the MessageSubscriptionIntent we want to make assertions on.
   */
  protected AbstractMessageSubscriptionIntentAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual MessageSubscriptionIntent should blacklist instance on error.
   * @return this assertion object.
   * @throws AssertionError - if the actual MessageSubscriptionIntent should not blacklist instance on error.
   */
  public S shouldBlacklistInstanceOnError() {
    // check that actual MessageSubscriptionIntent we want to make assertions on is not null.
    isNotNull();

    // check that property call/field access is true
    if (!actual.shouldBlacklistInstanceOnError()) {
      failWithMessage("\nExpecting that actual MessageSubscriptionIntent should blacklist instance on error but should not.");
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual MessageSubscriptionIntent should not blacklist instance on error.
   * @return this assertion object.
   * @throws AssertionError - if the actual MessageSubscriptionIntent should blacklist instance on error.
   */
  public S shouldNotBlacklistInstanceOnError() {
    // check that actual MessageSubscriptionIntent we want to make assertions on is not null.
    isNotNull();

    // check that property call/field access is false
    if (actual.shouldBlacklistInstanceOnError()) {
      failWithMessage("\nExpecting that actual MessageSubscriptionIntent should not blacklist instance on error but should.");
    }

    // return the current assertion for method chaining
    return myself;
  }

}
