package io.camunda.zeebe.protocol.record.intent;

import org.assertj.core.api.AbstractComparableAssert;

/**
 * Abstract base class for {@link JobIntent} specific assertions - Generated by CustomAssertionGenerator.
 */
@javax.annotation.Generated(value="assertj-assertions-generator")
public abstract class AbstractJobIntentAssert<S extends AbstractJobIntentAssert<S, A>, A extends JobIntent> extends AbstractComparableAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractJobIntentAssert}</code> to make assertions on actual JobIntent.
   * @param actual the JobIntent we want to make assertions on.
   */
  protected AbstractJobIntentAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual JobIntent should blacklist instance on error.
   * @return this assertion object.
   * @throws AssertionError - if the actual JobIntent should not blacklist instance on error.
   */
  public S shouldBlacklistInstanceOnError() {
    // check that actual JobIntent we want to make assertions on is not null.
    isNotNull();

    // check that property call/field access is true
    if (!actual.shouldBlacklistInstanceOnError()) {
      failWithMessage("\nExpecting that actual JobIntent should blacklist instance on error but should not.");
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual JobIntent should not blacklist instance on error.
   * @return this assertion object.
   * @throws AssertionError - if the actual JobIntent should blacklist instance on error.
   */
  public S shouldNotBlacklistInstanceOnError() {
    // check that actual JobIntent we want to make assertions on is not null.
    isNotNull();

    // check that property call/field access is false
    if (actual.shouldBlacklistInstanceOnError()) {
      failWithMessage("\nExpecting that actual JobIntent should not blacklist instance on error but should.");
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual JobIntent's intent is equal to the given one.
   * @param intent the given intent to compare the actual JobIntent's intent to.
   * @return this assertion object.
   * @throws AssertionError - if the actual JobIntent's intent is not equal to the given one.
   */
  public S hasIntent(short intent) {
    // check that actual JobIntent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting intent of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // check
    short actualIntent = actual.getIntent();
    if (actualIntent != intent) {
      failWithMessage(assertjErrorMessage, actual, intent, actualIntent);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
