package io.camunda.zeebe.protocol.record.intent;

import org.assertj.core.api.AbstractComparableAssert;

/**
 * Abstract base class for {@link DeploymentIntent} specific assertions - Generated by CustomAssertionGenerator.
 */
@javax.annotation.Generated(value="assertj-assertions-generator")
public abstract class AbstractDeploymentIntentAssert<S extends AbstractDeploymentIntentAssert<S, A>, A extends DeploymentIntent> extends AbstractComparableAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractDeploymentIntentAssert}</code> to make assertions on actual DeploymentIntent.
   * @param actual the DeploymentIntent we want to make assertions on.
   */
  protected AbstractDeploymentIntentAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual DeploymentIntent's intent is equal to the given one.
   * @param intent the given intent to compare the actual DeploymentIntent's intent to.
   * @return this assertion object.
   * @throws AssertionError - if the actual DeploymentIntent's intent is not equal to the given one.
   */
  public S hasIntent(short intent) {
    // check that actual DeploymentIntent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting intent of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // check
    short actualIntent = actual.getIntent();
    if (actualIntent != intent) {
      failWithMessage(assertjErrorMessage, actual, intent, actualIntent);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
