package io.camunda.zeebe.protocol.record.intent;

import org.assertj.core.api.AbstractComparableAssert;

/**
 * Abstract base class for {@link DeploymentDistributionIntent} specific assertions - Generated by CustomAssertionGenerator.
 */
@javax.annotation.Generated(value="assertj-assertions-generator")
public abstract class AbstractDeploymentDistributionIntentAssert<S extends AbstractDeploymentDistributionIntentAssert<S, A>, A extends DeploymentDistributionIntent> extends AbstractComparableAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractDeploymentDistributionIntentAssert}</code> to make assertions on actual DeploymentDistributionIntent.
   * @param actual the DeploymentDistributionIntent we want to make assertions on.
   */
  protected AbstractDeploymentDistributionIntentAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual DeploymentDistributionIntent's intent is equal to the given one.
   * @param intent the given intent to compare the actual DeploymentDistributionIntent's intent to.
   * @return this assertion object.
   * @throws AssertionError - if the actual DeploymentDistributionIntent's intent is not equal to the given one.
   */
  public S hasIntent(short intent) {
    // check that actual DeploymentDistributionIntent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting intent of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // check
    short actualIntent = actual.getIntent();
    if (actualIntent != intent) {
      failWithMessage(assertjErrorMessage, actual, intent, actualIntent);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
