package io.camunda.zeebe.protocol.record;

import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link RecordValueWithVariables} specific assertions - Generated by CustomAssertionGenerator.
 */
@javax.annotation.Generated(value="assertj-assertions-generator")
public abstract class AbstractRecordValueWithVariablesAssert<S extends AbstractRecordValueWithVariablesAssert<S, A>, A extends RecordValueWithVariables> extends AbstractObjectAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractRecordValueWithVariablesAssert}</code> to make assertions on actual RecordValueWithVariables.
   * @param actual the RecordValueWithVariables we want to make assertions on.
   */
  protected AbstractRecordValueWithVariablesAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual RecordValueWithVariables's variables is equal to the given one.
   * @param variables the given variables to compare the actual RecordValueWithVariables's variables to.
   * @return this assertion object.
   * @throws AssertionError - if the actual RecordValueWithVariables's variables is not equal to the given one.
   */
  public S hasVariables(java.util.Map variables) {
    // check that actual RecordValueWithVariables we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting variables of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";

    // null safe check
    java.util.Map actualVariables = actual.getVariables();
    if (!Objects.areEqual(actualVariables, variables)) {
      failWithMessage(assertjErrorMessage, actual, variables, actualVariables);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
