/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.process.test.qa.abstracts.util;

import io.camunda.zeebe.client.ZeebeClient;
import io.camunda.zeebe.client.api.command.DeployResourceCommandStep1;
import io.camunda.zeebe.client.api.response.ActivateJobsResponse;
import io.camunda.zeebe.client.api.response.DeploymentEvent;
import io.camunda.zeebe.client.api.response.ProcessInstanceEvent;
import io.camunda.zeebe.client.api.response.ProcessInstanceResult;
import io.camunda.zeebe.client.api.response.PublishMessageResponse;
import io.camunda.zeebe.process.test.api.RecordStreamSource;
import io.camunda.zeebe.process.test.api.ZeebeTestEngine;
import io.camunda.zeebe.process.test.filters.RecordStream;
import io.camunda.zeebe.process.test.filters.StreamFilter;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.intent.JobIntent;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utilities {
    private static final Logger LOG = LoggerFactory.getLogger(Utilities.class);

    public static DeploymentEvent deployResource(ZeebeClient client, String resource) {
        return Utilities.deployResources(client, resource);
    }

    public static DeploymentEvent deployResources(ZeebeClient client, String ... resources) {
        DeployResourceCommandStep1 commandStep1 = client.newDeployResourceCommand();
        DeployResourceCommandStep1.DeployResourceCommandStep2 commandStep2 = null;
        for (String process : resources) {
            commandStep2 = commandStep2 == null ? commandStep1.addResourceFromClasspath(process) : commandStep2.addResourceFromClasspath(process);
        }
        return (DeploymentEvent)commandStep2.send().join();
    }

    public static ProcessInstanceEvent startProcessInstance(ZeebeTestEngine engine, ZeebeClient client, String processId) throws InterruptedException, TimeoutException {
        return Utilities.startProcessInstance(engine, client, processId, new HashMap<String, Object>());
    }

    public static ProcessInstanceEvent startProcessInstance(ZeebeTestEngine engine, ZeebeClient client, String processId, Map<String, Object> variables) throws InterruptedException, TimeoutException {
        ProcessInstanceEvent instanceEvent = (ProcessInstanceEvent)client.newCreateInstanceCommand().bpmnProcessId(processId).latestVersion().variables(variables).send().join();
        Utilities.waitForIdleState(engine, Duration.ofSeconds(1L));
        return instanceEvent;
    }

    public static ProcessInstanceResult startProcessInstanceWithResult(ZeebeTestEngine engine, ZeebeClient client, String processId, Map<String, Object> variables) throws InterruptedException, TimeoutException {
        ProcessInstanceResult instanceResult = (ProcessInstanceResult)client.newCreateInstanceCommand().bpmnProcessId(processId).latestVersion().variables(variables).withResult().send().join();
        Utilities.waitForIdleState(engine, Duration.ofSeconds(1L));
        return instanceResult;
    }

    public static ActivateJobsResponse activateSingleJob(ZeebeClient client, String jobType) {
        return (ActivateJobsResponse)client.newActivateJobsCommand().jobType(jobType).maxJobsToActivate(1).send().join();
    }

    public static void waitForIdleState(ZeebeTestEngine engine, Duration duration) throws InterruptedException, TimeoutException {
        engine.waitForIdleState(duration);
    }

    public static void waitForBusyState(ZeebeTestEngine engine, Duration duration) throws InterruptedException, TimeoutException {
        engine.waitForBusyState(duration);
    }

    public static PublishMessageResponse sendMessage(ZeebeTestEngine engine, ZeebeClient client, String messageName, String correlationKey) throws InterruptedException, TimeoutException {
        return Utilities.sendMessage(engine, client, messageName, correlationKey, Duration.ZERO, Collections.emptyMap());
    }

    public static PublishMessageResponse sendMessage(ZeebeTestEngine engine, ZeebeClient client, String messageName, String correlationKey, Duration timeToLive, Map<String, Object> variables) throws InterruptedException, TimeoutException {
        PublishMessageResponse response = (PublishMessageResponse)client.newPublishMessageCommand().messageName(messageName).correlationKey(correlationKey).timeToLive(timeToLive).variables(variables).send().join();
        Utilities.waitForIdleState(engine, Duration.ofSeconds(1L));
        return response;
    }

    public static void increaseTime(ZeebeTestEngine engine, Duration duration) throws InterruptedException {
        try {
            Utilities.waitForIdleState(engine, Duration.ofSeconds(1L));
        }
        catch (TimeoutException e) {
            LOG.warn("Timeout reached while waiting for idle state", (Throwable)e);
        }
        engine.increaseTime(duration);
        try {
            Utilities.waitForBusyState(engine, Duration.ofSeconds(1L));
        }
        catch (TimeoutException e) {
            LOG.warn("Timeout reached while waiting for busy state after time increase", (Throwable)e);
        }
        try {
            Utilities.waitForIdleState(engine, Duration.ofSeconds(1L));
        }
        catch (TimeoutException e) {
            LOG.warn("Timeout reached while waiting for idle state after time increase", (Throwable)e);
        }
    }

    public static void completeTask(ZeebeTestEngine engine, ZeebeClient client, String taskId) throws InterruptedException, TimeoutException {
        List records = StreamFilter.jobRecords((RecordStream)RecordStream.of((RecordStreamSource)engine.getRecordStreamSource())).withElementId(taskId).withIntent(JobIntent.CREATED).stream().collect(Collectors.toList());
        StreamFilter.jobRecords((RecordStream)RecordStream.of((RecordStreamSource)engine.getRecordStreamSource())).withElementId(taskId).withIntent(JobIntent.COMPLETED).stream().forEach(record -> records.removeIf(r -> record.getKey() == r.getKey()));
        if (records.isEmpty()) {
            throw new IllegalStateException(String.format("Tried to complete task `%s`, but it was not found", taskId));
        }
        Record lastRecord = (Record)records.get(records.size() - 1);
        client.newCompleteCommand(lastRecord.getKey()).send().join();
        Utilities.waitForIdleState(engine, Duration.ofSeconds(1L));
    }

    public static void throwErrorCommand(ZeebeTestEngine engine, ZeebeClient client, long key, String errorCode, String errorMessage) throws InterruptedException, TimeoutException {
        client.newThrowErrorCommand(key).errorCode(errorCode).errorMessage(errorMessage).send().join();
        Utilities.waitForIdleState(engine, Duration.ofSeconds(1L));
    }

    public static final class FormPack {
        public static final String RESOURCE_NAME = "test-form.form";
        public static final String FORM_V2_RESOURCE_NAME = "test-form-v2.form";
        public static final String FORM_ID = "Form_0w7r08e";
    }

    public static final class ProcessPackNamedElements {
        public static final String RESOURCE_NAME = "named-elements.bpmn";
        public static final String RESOURCE_NAME_V2 = "named-elements-v2.bpmn";
        public static final String PROCESS_ID = "NamedProcess";
        public static final String START_EVENT_NAME = "Process started";
        public static final String START_EVENT_ID = "ProcessStartedStartEvent";
        public static final String TASK_NAME = "Do something";
        public static final String END_EVENT_NAME = "Process complete";
        public static final String END_EVENT_ID = "ProcessCompleteEndEvent";
    }

    public static final class ProcessPackAlternateStartEndEvent {
        public static final String RESOURCE_NAME = "alternate-start-end.bpmn";
        public static final String PROCESS_ID = "alternate-start-end";
    }

    public static final class ProcessPackStartEndEvent {
        public static final String RESOURCE_NAME = "start-end.bpmn";
        public static final String PROCESS_ID = "start-end";
    }

    public static final class ProcessPackCallActivity {
        public static final String RESOURCE_NAME = "call-activity.bpmn";
        public static final String PROCESS_ID = "call-activity";
        public static final String CALL_ACTIVITY_ID = "callactivity";
        public static final String CALLED_RESOURCE_NAME = "start-end.bpmn";
        public static final String CALLED_PROCESS_ID = "start-end";
    }

    public static final class ProcessPackMultipleCallActivity {
        public static final String RESOURCE_NAME = "multiple-call-activity.bpmn";
        public static final String PROCESS_ID = "multiple-call-activity";
        public static final String CALL_ACTIVITY_ID_ONE = "callactivityOne";
        public static final String CALLED_RESOURCE_NAME_ONE = "alternate-start-end.bpmn";
        public static final String CALLED_PROCESS_ID_ONE = "alternate-start-end";
        public static final String CALL_ACTIVITY_ID_TWO = "callactivityTwo";
        public static final String CALLED_RESOURCE_NAME_TWO = "call-activity.bpmn";
        public static final String CALLED_PROCESS_ID_TWO = "call-activity";
        public static final String CALLED_RESOURCE_NAME_THREE = "start-end.bpmn";
        public static final String CALLED_PROCESS_ID_THREE = "start-end";
    }

    public static final class ProcessPackTimerStartEvent {
        public static final String RESOURCE_NAME = "timer-start-event-daily.bpmn";
        public static final String TIMER_ID = "timer";
    }

    public static final class ProcessPackMessageStartEvent {
        public static final String RESOURCE_NAME = "message-start-event.bpmn";
        public static final String MESSAGE_NAME = "start-message";
        public static final String CORRELATION_KEY = "";
    }

    public static final class ProcessPackMessageEvent {
        public static final String RESOURCE_NAME = "message-event.bpmn";
        public static final String PROCESS_ID = "message-event";
        public static final String MESSAGE_NAME = "message";
        public static final String CORRELATION_KEY_VARIABLE = "correlationKey";
    }

    public static final class ProcessPackMultipleTasks {
        public static final String RESOURCE_NAME = "multiple-tasks.bpmn";
        public static final String PROCESS_ID = "multiple-tasks";
        public static final String ELEMENT_ID_1 = "servicetask1";
        public static final String ELEMENT_ID_2 = "servicetask2";
        public static final String ELEMENT_ID_3 = "servicetask3";
    }

    public static final class ProcessPackLoopingServiceTask {
        public static final String RESOURCE_NAME = "looping-servicetask.bpmn";
        public static final String PROCESS_ID = "looping-servicetask";
        public static final String ELEMENT_ID = "servicetask";
        public static final String JOB_TYPE = "test";
        public static final String TOTAL_LOOPS = "totalLoops";
        public static final String GATEWAY_ELEMENT_ID = "Gateway_0fhwf5d";
        public static final String LOOP_SEQUENCE_FLOW_ID = "loopSequenceFlow";
        public static final String START_EVENT_ID = "startevent";
        public static final String END_EVENT_ID = "endevent";
    }
}

