/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.process.test.qa.abstracts.multithread;

import io.camunda.zeebe.client.ZeebeClient;
import io.camunda.zeebe.client.api.response.ProcessInstanceResult;
import io.camunda.zeebe.process.test.api.ZeebeTestEngine;
import io.camunda.zeebe.process.test.assertions.BpmnAssert;
import io.camunda.zeebe.process.test.qa.abstracts.util.Utilities;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import org.junit.jupiter.api.Test;

public abstract class AbstractWorkerTest {
    @Test
    void testJobsCanBeProcessedAsynchronouslyByWorker() throws InterruptedException, TimeoutException {
        this.getClient().newWorker().jobType("test").handler((client, job) -> client.newCompleteCommand(job.getKey()).send()).open();
        Utilities.deployResource(this.getClient(), "looping-servicetask.bpmn");
        Map<String, Object> variables = Collections.singletonMap("totalLoops", 3);
        ProcessInstanceResult instanceEvent = Utilities.startProcessInstanceWithResult(this.getEngine(), this.getClient(), "looping-servicetask", variables);
        BpmnAssert.assertThat((ProcessInstanceResult)instanceEvent).isStarted();
        BpmnAssert.assertThat((ProcessInstanceResult)instanceEvent).hasPassedElement("servicetask", 3).isCompleted();
    }

    public abstract ZeebeClient getClient();

    public abstract ZeebeTestEngine getEngine();
}

