/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.process.test.qa.abstracts.multithread;

import io.camunda.zeebe.client.ZeebeClient;
import io.camunda.zeebe.client.api.response.ProcessInstanceEvent;
import io.camunda.zeebe.process.test.api.ZeebeTestEngine;
import io.camunda.zeebe.process.test.assertions.BpmnAssert;
import io.camunda.zeebe.process.test.filters.RecordStream;
import io.camunda.zeebe.process.test.qa.abstracts.util.Utilities;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public abstract class AbstractMultiThreadTest {
    private ExecutorService executorService;

    @BeforeEach
    void beforeEach() {
        this.executorService = Executors.newFixedThreadPool(5);
    }

    @AfterEach
    void afterEach() {
        this.executorService.shutdown();
    }

    @Test
    void testMultiThreadingThrowsNoExceptions() throws InterruptedException {
        List futures = this.executorService.invokeAll(Arrays.asList(new ProcessRunner(), new ProcessRunner(), new ProcessRunner(), new ProcessRunner(), new ProcessRunner()));
        for (Future future : futures) {
            try {
                Assertions.assertThat((Boolean)((Boolean)future.get())).isTrue();
            }
            catch (ExecutionException ex) {
                Assertions.fail((String)"Future completed exceptionally: %s", (Object[])new Object[]{ExceptionUtils.getStackTrace((Throwable)ex)});
            }
        }
    }

    public abstract ZeebeClient getClient();

    public abstract ZeebeTestEngine getEngine();

    public abstract RecordStream getRecordStream();

    private class ProcessRunner
    implements Callable<Boolean> {
        private ProcessRunner() {
        }

        @Override
        public Boolean call() throws InterruptedException, TimeoutException {
            BpmnAssert.initRecordStream((RecordStream)AbstractMultiThreadTest.this.getRecordStream());
            Utilities.deployResource(AbstractMultiThreadTest.this.getClient(), "start-end.bpmn");
            ProcessInstanceEvent instanceEvent = Utilities.startProcessInstance(AbstractMultiThreadTest.this.getEngine(), AbstractMultiThreadTest.this.getClient(), "start-end");
            Utilities.waitForIdleState(AbstractMultiThreadTest.this.getEngine(), Duration.ofSeconds(1L));
            BpmnAssert.assertThat((ProcessInstanceEvent)instanceEvent).isCompleted();
            BpmnAssert.resetRecordStream();
            return true;
        }
    }
}

