/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.process.test.qa.abstracts.mapper;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.camunda.zeebe.client.ZeebeClient;
import io.camunda.zeebe.client.api.JsonMapper;
import io.camunda.zeebe.process.test.api.ZeebeTestEngine;
import java.time.LocalDateTime;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class AbstractMapperSerializationDeserializationTest {
    protected ZeebeClient client;
    protected ZeebeTestEngine engine;
    protected ObjectMapper mapper = this.configureObjectMapper();

    @Test
    void shouldSerialize() {
        JsonMapper jsonMapper = this.client.getConfiguration().getJsonMapper();
        LocalDateTime localDateTime = LocalDateTime.of(2023, 7, 31, 12, 0, 0);
        String expectedJson = "\"2023-07-31T12:00:00\"";
        String actualJson = jsonMapper.toJson((Object)localDateTime);
        Assertions.assertEquals((Object)"\"2023-07-31T12:00:00\"", (Object)actualJson);
    }

    @Test
    void shouldDeserialize() {
        JsonMapper jsonMapper = this.client.getConfiguration().getJsonMapper();
        String json = "\"2023-07-31T12:00:00\"";
        LocalDateTime expectedLocalDateTime = LocalDateTime.of(2023, 7, 31, 12, 0, 0);
        LocalDateTime actualLocalDateTime = (LocalDateTime)jsonMapper.fromJson("\"2023-07-31T12:00:00\"", LocalDateTime.class);
        Assertions.assertEquals((Object)expectedLocalDateTime, (Object)actualLocalDateTime);
    }

    private ObjectMapper configureObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)new JavaTimeModule());
        objectMapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        return objectMapper;
    }
}

