/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.process.test.qa.abstracts.mapper;

import io.camunda.zeebe.client.ZeebeClient;
import io.camunda.zeebe.client.api.JsonMapper;
import io.camunda.zeebe.client.api.command.InternalClientException;
import io.camunda.zeebe.process.test.api.ZeebeTestEngine;
import java.time.LocalDateTime;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class AbstractMapperNotSerializationDeserializationTest {
    protected ZeebeClient client;
    protected ZeebeTestEngine engine;

    @Test
    void shouldNotSerialize() {
        JsonMapper jsonMapper = this.client.getConfiguration().getJsonMapper();
        LocalDateTime localDateTime = LocalDateTime.of(2023, 7, 31, 12, 0, 0);
        Assertions.assertThrows(InternalClientException.class, () -> jsonMapper.toJson((Object)localDateTime));
    }

    @Test
    void shouldNotDeserialize() {
        JsonMapper jsonMapper = this.client.getConfiguration().getJsonMapper();
        String json = "\"2023-07-31T12:00:00\"";
        Assertions.assertThrows(InternalClientException.class, () -> jsonMapper.fromJson("\"2023-07-31T12:00:00\"", LocalDateTime.class));
    }
}

