/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.process.test.qa.abstracts.jobs;

import io.camunda.zeebe.client.ZeebeClient;
import io.camunda.zeebe.client.api.response.ActivateJobsResponse;
import io.camunda.zeebe.client.api.response.ActivatedJob;
import io.camunda.zeebe.client.api.response.DeploymentEvent;
import io.camunda.zeebe.process.test.api.RecordStreamSource;
import io.camunda.zeebe.process.test.api.ZeebeTestEngine;
import io.camunda.zeebe.process.test.assertions.BpmnAssert;
import io.camunda.zeebe.process.test.filters.RecordStream;
import io.camunda.zeebe.process.test.qa.abstracts.util.Utilities;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRecordValue;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Optional;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public abstract class AbstractTimerTest {
    private static final String RESOURCE = "test_timer_events.bpmn";
    private static final String PROCESS_ID = "Process_Timer_Test_01";
    private ZeebeClient client;
    private ZeebeTestEngine engine;
    private RecordStream recordStream;

    private static Stream<Arguments> dates() {
        return Stream.of(Arguments.of((Object[])new Object[]{OffsetDateTime.of(2023, 10, 5, 15, 50, 0, 0, ZoneOffset.of("+02:00"))}), Arguments.of((Object[])new Object[]{OffsetDateTime.of(2023, 10, 31, 0, 0, 0, 0, ZoneOffset.of("+02:00"))}), Arguments.of((Object[])new Object[]{OffsetDateTime.of(2023, 10, 31, 23, 0, 0, 0, ZoneOffset.of("+02:00"))}), Arguments.of((Object[])new Object[]{OffsetDateTime.of(2023, 10, 31, 23, 59, 0, 0, ZoneOffset.of("+02:00"))}), Arguments.of((Object[])new Object[]{OffsetDateTime.of(2023, 10, 31, 23, 59, 59, 0, ZoneOffset.of("+02:00"))}), Arguments.of((Object[])new Object[]{OffsetDateTime.of(2023, 12, 31, 23, 59, 59, 0, ZoneOffset.of("+02:00"))}));
    }

    @BeforeEach
    void deployProcesses() {
        DeploymentEvent deploymentEvent = Utilities.deployResource(this.client, RESOURCE);
        BpmnAssert.assertThat((DeploymentEvent)deploymentEvent).containsProcessesByResourceName(new String[]{RESOURCE});
    }

    @ParameterizedTest
    @MethodSource(value={"dates"})
    void shouldCompareTimersDueDatesCorrectlyForDifferentNowDates(OffsetDateTime nowDate) throws Exception {
        Utilities.increaseTime(this.engine, Duration.between(OffsetDateTime.now(), nowDate));
        this.client.newCreateInstanceCommand().bpmnProcessId(PROCESS_ID).latestVersion().send().join();
        ActivateJobsResponse response = Utilities.activateSingleJob(this.client, "SimpleLog01");
        long key = ((ActivatedJob)response.getJobs().get(0)).getKey();
        this.client.newCompleteCommand(key).send().join();
        this.waitForProcessInstanceCompleted();
    }

    private void waitForProcessInstanceCompleted() {
        Awaitility.await().untilAsserted(() -> {
            Optional<Record> processCompleted = StreamSupport.stream(RecordStream.of((RecordStreamSource)this.engine.getRecordStreamSource()).processInstanceRecords().spliterator(), false).filter(r -> ((ProcessInstanceRecordValue)r.getValue()).getBpmnElementType() == BpmnElementType.PROCESS).filter(r -> ((ProcessInstanceRecordValue)r.getValue()).getBpmnProcessId().equals(PROCESS_ID)).filter(r -> r.getIntent() == ProcessInstanceIntent.ELEMENT_COMPLETED).findFirst();
            Assertions.assertThat(processCompleted).isNotEmpty();
        });
    }
}

