/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.process.test.qa.abstracts.inspections;

import io.camunda.zeebe.client.ZeebeClient;
import io.camunda.zeebe.client.api.response.ProcessInstanceEvent;
import io.camunda.zeebe.process.test.api.ZeebeTestEngine;
import io.camunda.zeebe.process.test.assertions.BpmnAssert;
import io.camunda.zeebe.process.test.inspections.InspectionUtility;
import io.camunda.zeebe.process.test.inspections.model.InspectedProcessInstance;
import io.camunda.zeebe.process.test.qa.abstracts.util.Utilities;
import java.util.Optional;
import java.util.concurrent.TimeoutException;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class AbstractProcessInstanceInspectionsTest {
    @Test
    void testStartedByProcessInstanceWithProcessId() throws InterruptedException, TimeoutException {
        Utilities.deployResources(this.getClient(), "call-activity.bpmn", "start-end.bpmn");
        ProcessInstanceEvent instanceEvent = Utilities.startProcessInstance(this.getEngine(), this.getClient(), "call-activity");
        Optional firstProcessInstance = InspectionUtility.findProcessInstances().withParentProcessInstanceKey(instanceEvent.getProcessInstanceKey()).withBpmnProcessId("start-end").findFirstProcessInstance();
        Assertions.assertThat((Optional)firstProcessInstance).isNotEmpty();
        BpmnAssert.assertThat((InspectedProcessInstance)((InspectedProcessInstance)firstProcessInstance.get())).isCompleted();
        BpmnAssert.assertThat((ProcessInstanceEvent)instanceEvent).hasPassedElement("callactivity").isCompleted();
    }

    @Test
    void testStartedByProcessInstanceWithProcessId_wrongId() throws InterruptedException, TimeoutException {
        Utilities.deployResources(this.getClient(), "call-activity.bpmn", "start-end.bpmn");
        ProcessInstanceEvent instanceEvent = Utilities.startProcessInstance(this.getEngine(), this.getClient(), "call-activity");
        Optional firstProcessInstance = InspectionUtility.findProcessInstances().withParentProcessInstanceKey(instanceEvent.getProcessInstanceKey()).withBpmnProcessId("wrongId").findFirstProcessInstance();
        Assertions.assertThat((Optional)firstProcessInstance).isEmpty();
    }

    public abstract ZeebeClient getClient();

    public abstract ZeebeTestEngine getEngine();
}

