/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.process.test.qa.abstracts.inspections;

import io.camunda.zeebe.client.ZeebeClient;
import io.camunda.zeebe.client.api.response.DeploymentEvent;
import io.camunda.zeebe.process.test.api.ZeebeTestEngine;
import io.camunda.zeebe.process.test.inspections.ProcessDefinitionInspectionUtility;
import io.camunda.zeebe.process.test.qa.abstracts.util.Utilities;
import java.time.Duration;
import java.util.concurrent.TimeoutException;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class AbstractProcessInspectionsTest {
    @Test
    void testFindStartEventIdByName() throws InterruptedException, TimeoutException {
        Utilities.deployResource(this.getClient(), "named-elements.bpmn");
        Utilities.deployResource(this.getClient(), "named-elements-v2.bpmn");
        this.getEngine().waitForIdleState(Duration.ofSeconds(1L));
        String startEventId = ProcessDefinitionInspectionUtility.getBpmnElementId((String)"Process started");
        Assertions.assertThat((String)startEventId).isEqualTo("ProcessStartedStartEvent");
    }

    @Test
    void testFindEndEventIdByBpmnProcessIdAndName() throws InterruptedException, TimeoutException {
        Utilities.deployResource(this.getClient(), "named-elements.bpmn");
        Utilities.deployResource(this.getClient(), "named-elements-v2.bpmn");
        this.getEngine().waitForIdleState(Duration.ofSeconds(1L));
        String endEventId = ProcessDefinitionInspectionUtility.getBpmnElementId((String)"NamedProcess", (String)"Process complete");
        Assertions.assertThat((String)endEventId).isEqualTo("ProcessCompleteEndEvent");
    }

    @Test
    void testFindEndEventIdByDeploymentAndName() throws InterruptedException, TimeoutException {
        DeploymentEvent deployment = Utilities.deployResource(this.getClient(), "named-elements.bpmn");
        this.getEngine().waitForIdleState(Duration.ofSeconds(1L));
        String endEventId = ProcessDefinitionInspectionUtility.getBpmnElementId((DeploymentEvent)deployment, (String)"Process complete");
        Assertions.assertThat((String)endEventId).isEqualTo("ProcessCompleteEndEvent");
    }

    @Test
    void testThrowIfNameIsNotUnique() throws InterruptedException, TimeoutException {
        Utilities.deployResource(this.getClient(), "named-elements.bpmn");
        Utilities.deployResource(this.getClient(), "named-elements-v2.bpmn");
        this.getEngine().waitForIdleState(Duration.ofSeconds(1L));
        Assertions.assertThatThrownBy(() -> ProcessDefinitionInspectionUtility.getBpmnElementId((String)"Do something")).isInstanceOf(AssertionError.class);
    }

    public abstract ZeebeClient getClient();

    public abstract ZeebeTestEngine getEngine();
}

